/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.*;
import java.util.*;
import org.kotemaru.auth.*;
import org.kotemaru.util.*;
import org.mozilla.javascript.*;

public  class AppConfig extends HashMap {
	private static final String	TIMEOUT      = "timeout";
	private static final String	SERVER_LOG   = "server_log";
	private static final String	CLIENT_CACHE = "clientcache";
	private static final String	XREQ_LIMIT   = "xreqLimit";

	private static final int	DAY = 24*60*60*1000; // 1DAY/ms
	//private static final int	DAY = 60*1000; // 1min/ms

	private final User owner;
	private long xreqCountResetTime = System.currentTimeMillis();
	private int xreqCount = 0;

	public AppConfig(User user, Map map) {
		super(map);
		this.owner = user;

		if (super.get(TIMEOUT) == null)      setTimeout(30);
		if (super.get(SERVER_LOG) == null)   setServer_log(false);
		if (super.get(CLIENT_CACHE) == null) setClientcache(true);
		if (super.get(XREQ_LIMIT) == null)   setXreqLimit(100);
	}

	public User getOwner() {
		return owner;
	}


	public int getTimeout() {
		return ((Number)super.get(TIMEOUT)).intValue();
	}
	public void setTimeout(int t) {
		super.put(TIMEOUT, new Integer(t));
	}

	public boolean isServerLog() {
		return ((Boolean)super.get(SERVER_LOG)).booleanValue();
	}
	public boolean getServer_log() {
		return ((Boolean)super.get(SERVER_LOG)).booleanValue();
	}
	public void setServer_log(boolean b) {
		super.put(SERVER_LOG, Boolean.valueOf(b));
	}

	public boolean isClientCache() {
		return ((Boolean)super.get(CLIENT_CACHE)).booleanValue();
	}
	public boolean getClientcache() {
		return ((Boolean)super.get(CLIENT_CACHE)).booleanValue();
	}
	public void setClientcache(boolean b) {
		super.put(CLIENT_CACHE, Boolean.valueOf(b));
	}


	public int getXreqLimit() {
		return ((Number)super.get(XREQ_LIMIT)).intValue();
	}
	public void setXreqLimit(int t) {
		super.put(XREQ_LIMIT, new Integer(t));
	}
	public int addXreqCount() {
		if (xreqCount >= getXreqLimit()) {
			long curTime = System.currentTimeMillis();
			if (curTime-DAY < xreqCountResetTime) {
				throw new ErrorPageException("xmlHttpRequestLimit", 
					""+getXreqLimit(), owner);
			} else {
				xreqCountResetTime = curTime;
				xreqCount = -1;
			}
		}
		return ++xreqCount;
	}


//-------------------------------------------------------------
// for-in supported.
	private static final String[] NAMES = {
		TIMEOUT,
		SERVER_LOG,
		CLIENT_CACHE,
	};
	public java.util.Iterator __iterator__(boolean b){
		return new MyIterator(NAMES);
	}
	public JavaScriptException __getStopIteratin() {
		Context cx = Context.getCurrentContext();
		Scriptable scope = cx.initStandardObjects();
		return new JavaScriptException(
			NativeIterator.getStopIterationObject(scope), null, 0);
	}
	private  class MyIterator implements java.util.Iterator {
		private Object[] array;
		private int idx = 0;
		public MyIterator(Object[] ary) {array = ary;}
		public boolean hasNext(){return idx<array.length;}
		public Object next(){
			if (idx>=array.length) throw __getStopIteratin();
			return array[idx++];
		}
		public void remove(){throw new Error("Unsupport");}
	}

}
