package org.kotemaru.util.gae;

import org.kotemaru.util.IOUtil;

import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;

public class GaeIOUtil {
	private static final String NS_MEMCACHE = GaeIOUtil.class.getName();
	private static MemcacheService memcache = 
		MemcacheServiceFactory.getMemcacheService(NS_MEMCACHE);
	
	public static String getResourceWithCache(Class clazz, String name) throws java.io.IOException {
		String resName = clazz.getName()+":"+name;
		String val = (String) memcache.get(resName);
		if (val == null) {
			val = IOUtil.getResource(clazz, name);
			memcache.put(resName, val); 
		}
		return val; 
	}
}
