/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.util.gae;

import java.io.*;
import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.IOUtil;
import org.kotemaru.wsjs.Config;

import com.google.appengine.api.datastore.*;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.appengine.api.memcache.*;

public class ConfigServlet extends HttpServlet {
	public static final DatastoreServiceFactory DSF = new DatastoreServiceFactory();
	private static final String NS_MEMCACHE = ConfigServlet.class.getName();
	private static MemcacheService memcache = 
		MemcacheServiceFactory.getMemcacheService(NS_MEMCACHE);

	private static final String KIND = "_WSJSConfig";
	private static final String CONFIG_JS = "config.js";
	private static final String BODY = "body";
	private File realPath;

	public void init(ServletConfig config) throws ServletException {
		try {
			String path = config.getServletContext().getRealPath("");
			realPath = new File(path);
		} catch (Exception e) {
			e.printStackTrace();
			throw new ServletException(e);
		}
	}

	private boolean checkAdmin(HttpServletResponse response)
			throws ServletException, IOException 
	{
		UserService userService = UserServiceFactory.getUserService();
		if (userService.getCurrentUser() != null && userService.isUserAdmin()) {
			return true;
		}
		response.sendRedirect(userService.createLoginURL("/_ah/Config"));
		return false;
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response) 
			throws ServletException, IOException 
	{
		if (!checkAdmin(response)) return;

		String text = getConfigText(realPath);
		String html =
 "<html><body>"
+"<h3>WSJS Config</h3>"
+"<form action='?' method='POST' >"
+"<textarea name='text' style='width:100%' rows='25' >"+text+"</textarea>"
+"<br/><input type='submit' />"
+"</form>"
+"</body></html>";

		response.setContentType("text/html; charset=UTF-8");
		response.getWriter().write(html);
	}

	public static String getConfigText(File realPath) {
		String text = (String) memcache.get(CONFIG_JS);
		if (text != null) return text;

		DatastoreService ds = DSF.getDatastoreService();
		Key key = KeyFactory.createKey(KIND, CONFIG_JS);
		try {
			Entity entity = ds.get(key);
			text = ((Text)entity.getProperty(BODY)).getValue();
			memcache.put(CONFIG_JS, text);
			return text;
		} catch (Exception e) {
			return getConfigTextOrg(realPath);
		}
	}

	private static String getConfigTextOrg(File realPath) {
		try {
			return IOUtil.getFile(new File(realPath, "/WEB-INF/config.js"));
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) 
			throws ServletException, IOException 
	{
		if (!checkAdmin(response)) return;

		String text = request.getParameter("text");
		Entity entity =	new Entity(KIND, CONFIG_JS);
		entity.setProperty(BODY, new Text(text));
		DatastoreService ds = DSF.getDatastoreService();
		ds.put(entity);
		memcache.put(CONFIG_JS, text);

		// Configのバイナリキャッシュ削除
		Config.memcache.clearAll();

		doGet(request, response);
	}
}
