/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.util.gae;
import java.io.*;
import com.google.appengine.api.memcache.*;

public class CacheClassLoader extends ClassLoader {
	private static final String NS_MEMCACHE = CacheClassLoader.class.getName();
	private static MemcacheService memcache = 
		MemcacheServiceFactory.getMemcacheService(NS_MEMCACHE);

	private static int size = 0;

	public CacheClassLoader(ClassLoader parent) {
		super(parent);
	}


    protected synchronized Class<?> loadClass(String name, boolean resolve)
			throws ClassNotFoundException
    {
//System.out.println("--loadClass:"+name);
		//if (!name.startsWith("org.apache.struts2.")
		//	&& !name.startsWith("com.opensymphony.")
		//) {
		if (
(
name.startsWith("java")
|| name.startsWith("com.google.")
|| name.startsWith("org.xml.sax.")
|| name.startsWith("org.w3c.")
|| name.startsWith("sun.")
|| name.startsWith("org.mortbay.")

//) && (
//!name.startsWith("org.xml.")
//&& name.equals("javax.xml.parsers.SAXParser")
)
		) {
			try {
//System.out.println("--loadClass:"+name);
				return getParent().loadClass(name);
			} catch (ClassNotFoundException e) {
				return loadClass0(name, resolve);
			}
		}
		return loadClass0(name, resolve);
	}


	private Class loadClass0(String name, boolean resolve) 
			throws ClassNotFoundException
	{
		Class clazz = findLoadedClass(name);
		if (clazz != null) return clazz;
		clazz = findClass(name);
		if (resolve) resolveClass(clazz);
		return clazz;
	}
/*--
	Class c = findLoadedClass(name);
	if (c == null) {
	    try {
		if (getParent() != null) {
		    c = getParent().loadClass(name, false);
		} else {
		    c = findBootstrapClass0(name);
		}
	    } catch (ClassNotFoundException e) {
	        // If still not found, then invoke findClass in order
	        // to find the class.
	        c = findClass(name);
	    }
	}
	if (resolve) {
	    resolveClass(c);
	}
	return c;
    }
--*/

	protected Class findClass(String name) throws ClassNotFoundException {

		try {
			String path = name.replace('.','/')+".class";
//System.out.println("------findClass:"+path);

			InputStream in = null;
			try {
				byte[] data = (byte[]) memcache.get(name);
				if (data == null) {
					in = getParent().getResourceAsStream(path);
					data = readBytes(in);
//size += data.length;
//System.out.println("size="+size);
					memcache.put(name, data);
				}
				Class clazz = defineClass(name, data, 0, data.length);
				return clazz;
			} finally {
				if (in != null) in.close();
			}
		} catch (Throwable t) {
			throw new ClassNotFoundException(name, t);
		}
	}
	private static byte[] readBytes(InputStream in) throws IOException {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		byte[] buff = new byte[4096];
		int n;
		while ((n=in.read(buff)) > 0) {
			out.write(buff, 0, n);
		}
		return out.toByteArray();
	}
}
