/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.util;

import java.io.*;
import java.util.*;
import javax.servlet.http.*;
import org.apache.commons.fileupload.*;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadUtil {
	private static int SIZE_MAX = 500*1024*1024; // 500M 
	private static int SIZE_THRESHOLD = 1024*1024; // 1M 
	private static String ENCODING = "UTF-8";

	public static ServletFileUpload getServletUploader()
			throws Exception  {
		return new ServletFileUpload();
	}
	public static DiskFileUpload getUploader()
			throws FileUploadException, IOException  {
		return getUploader(System.getProperty("java.io.tmpdir"));
	}
	public static DiskFileUpload getUploader(String tmpDir) 
			throws FileUploadException, IOException  {
		DiskFileUpload uploader = new DiskFileUpload();
		uploader.setSizeMax(500*1024*1024); // 500M 
		uploader.setSizeThreshold(1024*1024); // 1M
		uploader.setHeaderEncoding("UTF-8");
		uploader.setRepositoryPath(tmpDir);
		return uploader;
	}

/*
	public void upload(HttpServletRequest request, Processer proc)
				throws FileUploadException, IOException {
		DiskFileUpload uploader = getUploader();

		List<FileItem> list = uploader.parseRequest(request);
		Iterator<FileItem> ite = list.iterator();
		while(ite.hasNext()){
			if (!processing(ite.next())) break;
		}
	}

	public interface Processer {
		public boolean procesing(FileItem item)
				throws FileUploadException, IOException;
	}
*/

}
