/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.util;

import java.io.*;
import java.util.*;
import com.google.appengine.api.memcache.*;


public class Property extends HashMap {
	private static final String NS_MEMCACHE = Property.class.getName();
     private static MemcacheService memcache =
            MemcacheServiceFactory.getMemcacheService(NS_MEMCACHE); 

	public Property() {
		super();
	}
	public Property(Map origin) {
		super(origin);
	}

	public String get(String section, String localKey) {
		return (String)get(section+localKey);
	}


	public Property load(File file, String charset) throws IOException {
		FileInputStream in = new FileInputStream(file);
		try {
			InputStreamReader r = new InputStreamReader(in, charset);
			return load(r);
		} finally {
			in.close();
		}
	}
	public Property load(Class clazz, String name, String charset) 
		throws IOException {
/*--
		InputStream in = null;
		try {
			in = clazz.getResourceAsStream(name);
			InputStreamReader r = new InputStreamReader(in, charset);
			return load(r);
		} finally {
			if (in != null) in.close();
		}
--*/
		Reader r = getResourceAsReader(clazz, name, charset);
		if (r == null) return null;
		try {
			return load(r);
		} finally {
			r.close();
		}
	}
    private Reader getResourceAsReader(Class clazz, String name, String charset)
            throws IOException 
    {
        String cacheName = clazz.getName()+":"+name;
        String data = (String) memcache.get(cacheName);
        if (data == null) {
            data = IOUtil.getResource(clazz, name, charset);
            if (data == null) return null;
            memcache.put(cacheName, data);
        }
        return new StringReader(data);
    }

	public Property load(Reader r)  throws IOException {
		BufferedReader reader;
		if (r instanceof BufferedReader) {
			reader = (BufferedReader) r;
		} else {
			reader = new BufferedReader(r);
		}

		String section = "";
		String line;
		while ((line = reader.readLine()) != null) {

			String next = "\\";
			while (next != null && line.length() > 0 
					&& line.charAt(line.length()-1) == '\\') {
				next = reader.readLine();
				line = line.substring(0, line.length()-1) + next;
			}

			if (line.length() == 0 || line.charAt(0) == '#') {
				// comment.
			} else if (line.charAt(0) == '[') {
				section = line.trim();
			} else {
				int pos = line.indexOf('=');
				if (pos>0) {
					String name = section + line.substring(0,pos).trim();
					String val  = line.substring(pos+1).trim();
					this.put(name, val);
				}
			}
		}
		return this;
	}
	public void save(Writer writer)	throws IOException {
		HashMap<String, StringBuffer> sections = new HashMap<String, StringBuffer>();

		Iterator<Map.Entry> ite = this.entrySet().iterator();
		while(ite.hasNext()){
			Map.Entry ent = ite.next();
			String key = (String) ent.getKey();
			int pos = key.indexOf(']');
			String section = "";
			String localKey = key;
			if (pos>0) {
				section = key.substring(0, pos+1);
				localKey = key.substring(pos);
			}
			StringBuffer sbuf = sections.get(section);
			if (sbuf == null) {
				sbuf = new StringBuffer("\n"+section+"\n");
				sections.put(section, sbuf);
			}
			sbuf.append(localKey);
			sbuf.append('=');
			String val = ((String)ent.getValue()).replaceAll("\\n","\\\n");
			sbuf.append(val);
			sbuf.append('\n');
		}

		Iterator<StringBuffer> ite2 = sections.values().iterator();
		while(ite2.hasNext()){
			StringBuffer sbuf = ite2.next();
			writer.append(sbuf);
		}
		writer.flush();

	}


}
