/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.util;

import java.io.* ;
import java.net.* ;
import java.util.* ;

public class NetUtil {
	private static final String UTF8 = "UTF-8";

	public static String encodeURI(String str) {
		return encodeURI(str, UTF8);
	}
	public static String encodeURI(String str, String charset) {
		if (str == null) return null;
		try {
			return java.net.URLEncoder.encode(str, charset);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
        }
    }
	public static String decodeURI(String str) {
		return decodeURI(str, UTF8);
	}
	public static String decodeURI(String str, String charset) {
		if (str == null) return null;
		try {
			return java.net.URLDecoder.decode(str, charset);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
        }
    }

}
