/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.util;

import java.io.* ;
import java.net.* ;
import java.util.* ;

public class Mutex  {
	private static HashMap<String,Mutex> instances = new HashMap<String,Mutex>();
	private Object lockOwner = null; 

	public static Mutex getInstance(String name) {
		synchronized (instances) {
			Mutex mutex = instances.get(name);
			if (mutex == null) {
				mutex = new Mutex();
				instances.put(name, mutex);
			}
			return mutex;
		}
	}

	public void lock(Object owner) {
		lock(owner, 10000);
	}

	public synchronized void lock(Object owner, int timeout) {
		while (lockOwner != null) {
			try {wait(timeout);}catch(Exception e){}
		}
		lockOwner = owner;
	}

	public synchronized void unlock(Object owner) {
		if (lockOwner != owner) {
			throw new RuntimeException("Bad lock owner "+lockOwner);
		}
		lockOwner = null;
		notify();
	}

	public synchronized boolean isLock() {
		return (lockOwner != null);
	}





}
