/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.util;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;

public class LOG {
	public static final int ERROR  = 1;
	public static final int ACCESS = 2;
	public static final int WARN   = 3;
	public static final int INFO   = 4;
	public static final int DEBUG  = 5;

	public static PrintStream out = System.out;
	public static int level = WARN;

	public static boolean isErrorEnabled() {return ERROR  <= level;}
	public static boolean isAccessEnabled(){return ACCESS <= level;}
	public static boolean isWarnEnabled()  {return WARN   <= level;}
	public static boolean isInfoEnabled()  {return INFO   <= level;}
	public static boolean isDebugEnabled() {return DEBUG  <= level;}
                                
	public static final void error(Throwable t) {
		if (!isErrorEnabled()) return;
		println(out, "ERROR ", t.getMessage());		
		t.printStackTrace(out);
	}
	public static final void error(String msg) {
		if (!isErrorEnabled()) return;
		println(out, "ERROR ", msg);		
	}
	public static final void access(String msg) {
		if (!isAccessEnabled()) return;
		println(out, "ACCESS", msg);		
	}
	public static final void warn(String msg) {
		if (!isWarnEnabled()) return;
		println(out, "WARN  ", msg);		
	}
	public static final void info(String msg) {
		if (!isInfoEnabled()) return;
		println(out, "INFO  ", msg);		
	}
	public static final void debug(String msg) {
		if (!isDebugEnabled()) return;
		println(out, "DEBUG ", msg);		
	}

	private static DateFormat dateFmt =
		new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
	private static StringBuffer buffer = new StringBuffer();
	public static final void println(OutputStream out, String lvl, String msg) {
		// TODO: 最適化
		synchronized (dateFmt) {
			buffer.setLength(0);
			dateFmt.format(new Date(), buffer, new FieldPosition(0));
			buffer.append(" [");
			buffer.append(lvl);
			buffer.append("] ");
			buffer.append(msg);
			buffer.append("\n");
			try {
				out.write(buffer.toString().getBytes());
				out.flush();
			} catch (IOException e) {
				// ignore.
			}
		}
	}

}
