/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Properties;

import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public abstract class ErrorPageExceptionBase extends RuntimeException {
    public static final String PROP_FILE = "ErrorPage.properties";
    private static final String UTF8 = "UTF-8";
    private static final String DUMMY_DATA_FOR_IE6_BUG = ""
		+"                                                       "
		+"                                                       "
		+"                                                       "
		+"                                                       "
		+"                                                       "
		+"                                                       "
		+"                                                       "
		+"                                                       "
		+"                                                       "
		+"                                                       "
		+"                                                       ";

	private static Property errorPageProp ;

	private int statusCode;
	private String errorId;
	private Object[] args;

	protected static void loadProperty(Class clazz, String enc) {
		try {
			errorPageProp =	new Property().load(clazz, PROP_FILE, enc);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}


	public ErrorPageExceptionBase(int code, String id, Object ... arg) {
		super(id);
		statusCode = code;
		errorId = id;
		args = arg;
	}
	
	public int getStatusCode() {
		return statusCode;
	}
	public String getErrorId() {
		return errorId;
	}

	public ErrorPageExceptionBase(String id, Object ... arg) {
		this(403, id, arg);
	}

	public ErrorPageExceptionBase(int code, Throwable t) {
		this(code, "internal", t.toString(), getStackTrace(t));
	}
	private static String getStackTrace(Throwable t) {
		StackTraceElement[] ste = t.getStackTrace();
		StringBuffer sbuf = new StringBuffer();
		for (int i=0; i<ste.length; i++) {
			sbuf.append(ste[i].toString());
			sbuf.append('\n');
		}
		return sbuf.toString();
	}

	public ErrorPageExceptionBase(Throwable t) {
		this(500, "internal", t.toString(), getStackTrace(t));
	}


	public String getBody() {
		try {
			String header = errorPageProp.get("[header]","content");
			String footer = errorPageProp.get("[footer]","content");
			String msg = header + errorPageProp.get("[message]",errorId) + footer;

			msg = msg.replaceAll("[$][{]errorId[}]", errorId);
			for (int i=0; i<args.length; i++) {

				// NOTE: java regexp bug.
				// msg = msg.replaceFirst("[$][{]"+(i+1)+"[}]", arg); 

				String key = "${"+(i+1)+"}";
				String val = "";
				if (args[i] instanceof Throwable) {
					Throwable t = (Throwable)args[i];
					val = t.toString()+"\n"+getStackTrace(t);
				} else if (args[i] != null) {
					val = args[i].toString();
				}
				val = val.replaceAll("&","&amp;").replaceAll("<","&lt;");

				StringBuffer sbuf = new StringBuffer(msg);
				int pos = sbuf.indexOf(key, 0);
				while (pos > 0) {
					sbuf.replace(pos, pos+key.length(), val);
					pos = sbuf.indexOf(key, pos);
				}
				msg = sbuf.toString();
			}
			return msg;
		} catch (Throwable e) {
			e.printStackTrace();
			LOG.error(e.toString());
			return e.toString();
		}
	}

    public void doForward(HttpServletRequest req, HttpServletResponse res) throws IOException {
		res.setStatus(statusCode);
		res.setContentType("text/html; charset="+UTF8);
		res.setCharacterEncoding(UTF8);
		OutputStreamWriter writer = null;
		try {
			writer = new OutputStreamWriter(res.getOutputStream(), UTF8);
			String body = getBody();
			if (body.length() < 512) {
				body += DUMMY_DATA_FOR_IE6_BUG;
			}
			writer.write(body);
			writer.flush();
			res.flushBuffer();
		} finally {
			if(writer != null) {
				writer.close();
			}
		}
    }

	public String getMessage() {
		String str = errorId+"[";
		for (int i=0; i<args.length; i++) {
			str = str + args[i]+",";
		}
		return str +"]";
	}


	public String toString() {
		return "ErrorPage:"+statusCode+" "+getMessage();
	}

}




