/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.servlet;
import java.util.Map;
import javax.servlet.http.*;
import org.kotemaru.auth.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;

public class PAMImpl extends PAMBase {
	private final IdProvider idProvider;

	public PAMImpl(Map props) {
		super(props);
		idProvider = new IdProviderImpl("http://localhost/");
	}

	public String getName() {
		return "servlet";
	}
	public String getDescription() {
		return "This PAM depends on servlet server.";
	}
	public IdProvider getIdProvider() {
		return idProvider;
	}
	public boolean isServletAuth() {
		return true;
	}

	public AuthResult authForRequest(HttpServletRequest request) throws Exception {
		String uid = request.getRemoteUser();
		if (uid != null) {
			User user = new UserImpl(this, PAMFactory.getRoleManager(), uid, request);
			return new AuthResultImpl(this, AuthResult.PASS, user);
		} else {
			User user = new VisitUser(this);
			return new AuthResultImpl(this, AuthResult.FAIL, user);
		}
	}

	public AuthResult authenticate(HttpServletRequest request, Map props) throws Exception {
		throw new UnsupportedOperationException();
	}


}
