/*
 * Copyright 2006-2008 Sxip Identity Corporation
 * Modified kotemaru@kotemaru.org
 */


package org.kotemaru.auth.openid;

import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.ax.AxMessage;
import org.openid4java.message.sreg.SRegMessage;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;
import org.openid4java.message.*;
import org.openid4java.OpenIDException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import java.util.List;
import java.io.IOException;

import org.openid4java.consumer.*;

/**
 * Based SampleConsumer.java
 */
public class OpenIDConsumer
{
	private static final String NICKNAME = "nickname";

	private ConsumerManager manager;
	private String returnToUrl;
	private DiscoveryInformation discovered = null;
	private AuthRequest authRequest = null;

	public OpenIDConsumer(String returnToUrl) throws ConsumerException
	{
		this.returnToUrl = returnToUrl;
		manager = new ConsumerManager();
		manager.setAssociations(new InMemoryConsumerAssociationStore());
		manager.setNonceVerifier(new InMemoryNonceVerifier(5000));
		manager.getRealmVerifier().setEnforceRpId(false);
	}

	public DiscoveryInformation getDiscovered() {
		return discovered;
	}
	public AuthRequest getAuthRequest() {
		return authRequest;
	}


	// --- placing the authentication request ---
	public AuthRequest authRequest(String userSuppliedString)
			throws IOException
	{
		try {

			// --- Forward proxy setup (only if needed) ---
			// ProxyProperties proxyProps = new ProxyProperties();
			// proxyProps.setProxyName("proxy.example.com");
			// proxyProps.setProxyPort(8080);
			// HttpClientFactory.setProxyProperties(proxyProps);

			List discoveries = manager.discover(userSuppliedString);
			discovered = manager.associate(discoveries);
			authRequest = manager.authenticate(discovered, returnToUrl);

/*--
			FetchRequest fetch = FetchRequest.createFetchRequest();
			fetch.addAttribute(NICKNAME, // attribute alias
			    "http://schema.openid.net/contact/email", // type URI
			    true); // required
			authRequest.addExtension(fetch);
--*/
			SRegRequest sregReq = SRegRequest.createFetchRequest();
			sregReq.addAttribute(NICKNAME, true);
			authRequest.addExtension(sregReq);

			if (!discovered.isVersion2()) {
				//httpResp.sendRedirect(authRequest.getDestinationUrl(true));
				return authRequest;
			} else {
				// TODO:良く分からん。
				// Option 2: HTML FORM Redirection (Allows payloads >2048 bytes)

				//RequestDispatcher dispatcher =
				//		getServletContext().getRequestDispatcher("formredirection.jsp");
				//httpReq.setAttribute("prameterMap", response.getParameterMap());
				//httpReq.setAttribute("destinationUrl", response.getDestinationUrl(false));
				//dispatcher.forward(request, response);
			 }
		} catch (OpenIDException e) {
			throw new RuntimeException(e);
		}

		return null;
	}

	public String[] verifyResponse(HttpServletRequest httpReq) {
		try {
			ParameterList response =
					new ParameterList(httpReq.getParameterMap());

			// extract the receiving URL from the HTTP request
			StringBuffer receivingURL = httpReq.getRequestURL();
			String queryString = httpReq.getQueryString();
			if (queryString != null && queryString.length() > 0)
				receivingURL.append("?").append(httpReq.getQueryString());

			VerificationResult verification = manager.verify(
					receivingURL.toString(),
					response, discovered);

			String openid = verification.getVerifiedId().getIdentifier();
			AuthSuccess authSuccess = (AuthSuccess) verification.getAuthResponse();

           //FetchResponse fetchResp = (FetchResponse) authSuccess.getExtension(AxMessage.OPENID_NS_AX);
           //String nickname = fetchResp.getAttributeValues(NICKNAME).get(0);

			SRegResponse sregRes = (SRegResponse) authSuccess.getExtension(SRegMessage.OPENID_NS_SREG);
			String nickname = sregRes.getAttributeValue(NICKNAME);

			String[] result = {openid, nickname};
			return result;
		} catch (OpenIDException e) {
			throw new RuntimeException(e);
		}
	}

}
