/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.localfile;
import java.util.*;
import javax.servlet.http.*;
import org.kotemaru.auth.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;
import org.kotemaru.util.json.*;
import org.kotemaru.util.*;

/**
ローカルファイル用UserManager。
usersDir=/tmp/users
registerUrl=http://localhost/login/register-OpenID.ssjs
*/

public class UserManagerImpl implements UserManager  {
	private static final Set NIL_ROLES = new HashSet();
	protected static final String RETURN_URL = "returnUrl";
	protected static final String LOGIN_URL = "loginUrl";
	protected static final String CHARSET = "charset";

	private final File usersDir;
	private final String registerUrl;

	static class UserInfo extends HashMap {
		public long lastModified;
		public UserInfo() {super();}
		public UserInfo(Map map) {super(map);}
	}
	private Map<String,UserInfo>  users = new HashMap();
	private Map<String,String>    usersRv = new HashMap();


	public UserManagerImpl(Map props) throws IOException {
		usersDir    = new File((String) props.get("usersDir"));
		registerUrl = (String)props.get("registerUrl");
		makeUsersList();
	}

	private synchronized void makeUsersList() throws IOException {
		usersRv.clear();

		JSONParser parser = new JSONParser();
		File[] files = usersDir.listFiles();
		for (int i=0; i<files.length; i++) {
			Reader reader = new FileReader(files[i]);
			try {
				Map info = parser.parse(reader);
				String uid  = (String)info.get(ID);
				String name = (String)info.get(NAME);
				if (name != null) usersRv.put(name, uid);
			} finally {
				reader.close();
			}
		}
	}


	public Map getUserInfo(User user) {
		return getUserInfo(user.getName(), user.getId());
	}
	public synchronized Map getUserInfo(String name, String uid) {
		try {
			if (uid == null) {
				uid = usersRv.get(name);
				if (uid == null) return null;
			}

			File userFile = new File(usersDir, uid);
			if (!userFile.exists()) {
				users.remove(uid);
				return null;
			}

			UserInfo info = users.get(uid);
			if (info != null &&
				info.lastModified >= userFile.lastModified()) {
					return info;
			}

			Reader reader = new FileReader(userFile);
			try {
				JSONParser parser = new JSONParser();
				info = new UserInfo(parser.parse(reader));
				info.lastModified = userFile.lastModified();
				users.put(uid, info);
				return info;
			} finally {
				reader.close();
			}
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}


	public void putUserInfo(User user, Map info) {
		putUserInfo(user.getName(), user.getId(), (UserInfo)info);
	}
	private synchronized void putUserInfo(String name, String uid, UserInfo info) {
		try {
			users.put(uid, info);
			if (name != null) usersRv.put(name, uid);

			File userFile = new File(usersDir, uid);
			OutputStream out = new FileOutputStream(userFile);
			try {
				JSONSerializer serial = new JSONSerializer();
				serial.serialize(info, out);
			} finally {
				out.close();
			}
			info.lastModified = userFile.lastModified();
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public synchronized Map createUser(String name, String uid) {
		if (getUserInfo(name, uid) != null) {
			throw new RuntimeException("User exists "+uid);
		}
		if (!AuthUtil.isValidUserName(name)) {
			name = null;
		}

		UserInfo info = new UserInfo();
		info.put(ID, uid);
		info.put(NAME, name);
		info.put(ATTRS, new HashMap());
		putUserInfo(name, uid, info);
		return info;
	}

	public synchronized Map register(String name, String uid) {
		if (!AuthUtil.isValidUserName(name)) {
			return null;
		}
		if (usersRv.get(name) != null) {
			return null;
		}

		UserInfo info = (UserInfo) getUserInfo(name, uid);
		if (info == null) info = (UserInfo) createUser(name, uid);
		info.put(NAME, name);
		putUserInfo(name, uid, info);
		return info;
	}


	public String getRegisterURL(HttpServletRequest request, String returnUrl, String charset) {
//		try {
			return registerUrl;
//				+"?"+RETURN_URL+"=" + URLEncoder.encode(returnUrl, charset)
//				+"&"+CHARSET+"=" + charset;
//		} catch (UnsupportedEncodingException e) {
//			throw new RuntimeException(e);
//		}
	}
}
