/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.localfile;
import java.util.*;
import javax.servlet.http.*;
import org.kotemaru.auth.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;

/**
ローカルファイル用RoleManager。
*/

public class RoleManagerImpl implements RoleManager  {
	private static final Set NIL_ROLES = new HashSet();

	private final File userDefFile; 
	private long lastUpdateTime = -1;
	private OnMemoryUserDB userDB;

	public RoleManagerImpl(Map props) throws IOException {
		String userDef = (String) props.get("userDef");
		userDefFile = new File(userDef);
		update();
	}

	private void update() {
		if (lastUpdateTime >= userDefFile.lastModified()) return;
		try {
			lastUpdateTime = userDefFile.lastModified();
			userDB = new OnMemoryUserDB("file:"+userDefFile);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public int getRoleState(User user, String role) {
		update();
		OnMemoryUserDB.UserDef userDef = userDB.getUserDef(user.getName());
		if (userDef == null) return MOOT;
		return userDef.getRoles().contains(role) ? ALLOW : MOOT;
	}
	public Set getRoles(User user) {
		update();
		OnMemoryUserDB.UserDef userDef = userDB.getUserDef(user.getName());
		if (userDef == null) return NIL_ROLES;
		return userDef.getRoles();
	}

}
