/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.localfile;
import java.util.*;
import javax.servlet.http.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;
import org.kotemaru.auth.*;
import org.kotemaru.util.*;


/**
ローカルファイル用PAM。

Ex:
class=org.kotemaru.auth.localfile.PAMImpl
userDef=file:/tmp/userDef.txt
loginUrl=/wsjs/login/login.html


userDef.txt:
#user:pass(MD5):role,...
admin:21232f297a57a5a743894a0e4a801fc3:admin,manager
tomcat:1b359d8753858b55befa0441067aaed3:manager
guest:084e0343a0486ff05530df6c705c8bb4:guest


*/

public class PAMImpl extends PAMBase  {
	private final OnMemoryUserDB userDB;
	private final IdProvider idProvider;

	public PAMImpl(Map props) throws IOException {
		super(props);
		String userDef = (String) props.get("userDef");
		userDB = new OnMemoryUserDB(userDef);
		idProvider = new IdProviderImpl("file:/"+userDef);
	}

	public String getName() {
		return "localfile";
	}

	public String getDescription() {
		return "This PAM depends on user define local file.\n";
	}
	public IdProvider getIdProvider() {
		return idProvider;
	}

	public AuthResult authForRequest(HttpServletRequest request) throws Exception {
		return new AuthResultImpl(this, AuthResult.MOOT, PAMFactory.getVisitUser());
	}
	public AuthResult authenticate(HttpServletRequest request, Map props) throws Exception {
		return authenticate(
			(String)props.get("user"),
			(String)props.get("pass")
		);
	}


	private AuthResult authenticate(String user, String pass) throws Exception {
		if (user == null || pass == null) {
			return new AuthResultImpl(this, AuthResult.MOOT, PAMFactory.getVisitUser());
		}

		byte[] md5pass = HexUtil.md5raw(pass);
		OnMemoryUserDB.UserDef userDef = userDB.getUserDef(user);
		if (userDef != null && userDef.isMatchPasswd(md5pass)) {
			User user0 = new UserImpl(this, PAMFactory.getRoleManager(), user);
			return new AuthResultImpl(this, AuthResult.PASS, user0);
		} else {
			return new AuthResultImpl(this, AuthResult.FAIL, PAMFactory.getVisitUser());
		}
	}


}
