/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.localfile;
import java.util.*;
import javax.servlet.http.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;
import org.kotemaru.auth.*;
import org.kotemaru.util.*;

/**
*/

public class OnMemoryUserDB {
	private final Map<String, UserDef> userDB;

	public OnMemoryUserDB(String url) throws IOException{
		userDB = load(new URL(url));
	}

	public UserDef getUserDef(String user) {
		return userDB.get(user);
	}

	private static Map<String, UserDef> load(URL url) throws IOException {
		InputStream in = url.openStream();
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(in));
			Map<String, UserDef> map = new HashMap<String, UserDef>();

			String line;
			while ((line = reader.readLine()) != null) {
				if (line.startsWith("#")) continue;

				String[] part = line.split(":");
				String[] roles = part[2].split(",");
				HashSet roleSet = new HashSet();
				for (int i=0; i<roles.length; i++) roleSet.add(roles[i].trim());

				UserDef userDef = new UserDef(part[0].trim(),
						HexUtil.decodeHexBytes(part[1].trim()), roleSet);
				map.put(part[0], userDef);
			}
			return map;
		} finally {
			in.close();
		}
	}

	static class UserDef {
		private final String name;
		private final byte[] pass;
		private final Set roles;

		public UserDef(String name, byte[] pass, Set roles) {
			this.name = name;
			this.pass = pass;
			this.roles = roles;
		}

		public String getName() {
			return name;
		}
		public boolean isMatchPasswd(byte[] md5pass) {
			if (pass.length != md5pass.length) return false;
			for (int i=0; i<pass.length; i++) {
				if (pass[i] != md5pass[i]) return false;
			}
			return true;
		}

		public Set getRoles() {
			return roles;
		}
	}

}
