/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.ldap;
import java.util.*;
import javax.servlet.http.*;
import org.kotemaru.auth.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;

/**
LDAP用PAM。

Ex:
class=org.kotemaru.auth.ldap.PAMImpl
java.naming.provider.url=ldap://localhost/
java.naming.security.authentication=simple
java.naming.security.principal=uid=${user},ou=People,dc=exsample,dc=com
java.naming.security.credentials=${passwd}
loginUrl=http://localhost/login/login.html

*/

public class PAMImpl extends PAMBase  {
	private final Map props;
	private final Hashtable enviroment = new Hashtable();
	private final Hashtable envAnonymous;
	private final String principal;
	private final String credentials;
	private final IdProvider idProvider;

	public PAMImpl(Map props) {
		super(props);
		this.props = props;

		principal =   (String) props.get(Context.SECURITY_PRINCIPAL);
		credentials = (String) props.get(Context.SECURITY_CREDENTIALS);
   		idProvider = new IdProviderImpl((String) props.get("java.naming.provider.url"));
                               
	    enviroment.put(Context.INITIAL_CONTEXT_FACTORY,
							"com.sun.jndi.ldap.LdapCtxFactory" );

		Iterator ite = props.entrySet().iterator();
		while(ite.hasNext()){
			Map.Entry ent = (Map.Entry) ite.next();
			String name = (String) ent.getKey();
			if (name.startsWith("java.naming.")) {
				enviroment.put(name, ent.getValue());
			}
		}

		envAnonymous = (Hashtable) enviroment.clone();
		envAnonymous.remove(Context.SECURITY_PRINCIPAL);
		envAnonymous.remove(Context.SECURITY_CREDENTIALS);
	}

	public String getName() {
		return "ldap";
	}

	public String getDescription() {
		return "This PAM depends on LDAP server.\n"+props;
	}
	public IdProvider getIdProvider() {
		return idProvider;
	}

	public AuthResult authForRequest(HttpServletRequest request) throws Exception {
		return new AuthResultImpl(this, AuthResult.MOOT, PAMFactory.getVisitUser());
	}
	public AuthResult authenticate(HttpServletRequest request, Map props) throws Exception {
		return authenticate(
			(String)props.get("user"),
			(String)props.get("pass")
		);
	}


	private AuthResult authenticate(String user, String pass) throws Exception {
		if (user == null || pass == null) {
			User user0 = new VisitUser(this);
			return new AuthResultImpl(this, AuthResult.MOOT, user0);
		}

		Hashtable env = new Hashtable(enviroment);
		env.put(Context.SECURITY_PRINCIPAL,
						principal.replaceAll("[$][{]user[}]", user));
		env.put(Context.SECURITY_CREDENTIALS,
						credentials.replaceAll("[$][{]passwd[}]", pass));
		DirContext ctx = null;
		try {
			ctx = new InitialDirContext(env);
		} catch (AuthenticationException e) {
			User user0 = new VisitUser(this);
			return new AuthResultImpl(this, AuthResult.FAIL, user0);
		} finally {
			if (ctx != null) ctx.close();
		}

		User user0 = new UserImpl(this, PAMFactory.getRoleManager(), user);
		return new AuthResultImpl(this, AuthResult.PASS, user0);
	}


}
