/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.gae;
import javax.servlet.http.*;
import org.kotemaru.auth.*;
import java.util.*;

public class UserImpl extends UserBase {
	private boolean isAdmin = false;

	public UserImpl(PAM pam, RoleManager roleMan, IdProvider idp, String name, String id) {
		super(pam, roleMan, idp, name, id);
	}

	/**
	 * コンストラクタ。
	 * @param pam 認証したPAMインスタンス
	 * @param name ユーザ名
	 */
	public UserImpl(PAM pam, RoleManager roleMan, String name) {
		super(pam, roleMan, pam.getIdProvider(), name);
	}

	/* package */ void setAdmin(boolean b) {
		isAdmin = b;
	}

	public boolean hasRole(String role) {
		if (isAdmin && ADMIN.equals(role)) return true;
		return super.hasRole(role);
	}

}




