/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.gae;
import java.util.Map;
import javax.servlet.http.*;
import org.kotemaru.auth.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import org.kotemaru.util.LOG;

public class PAMImpl extends PAMBase {
	private final IdProvider idProvider;

	public PAMImpl(Map props) {
		super(props);
		idProvider = new IdProviderImpl("http://appengine.google.com/");
	}

	public String getName() {
		return "servlet";
	}
	public String getDescription() {
		return "This PAM depends on GAE server.";
	}
	public IdProvider getIdProvider() {
		return idProvider;
	}
	public boolean isServletAuth() {
		return true;
	}

	public AuthResult authForRequest(HttpServletRequest request) throws Exception {
		UserService userService = UserServiceFactory.getUserService();
		String uid = (userService.getCurrentUser() == null) ? null 
					: userService.getCurrentUser().getEmail();
		if (uid != null) {
			//LOG.info("Login google user "+uid);
			UserImpl user = new UserImpl(this, PAMFactory.getRoleManager(), uid);
			user.setAdmin(userService.isUserAdmin());
			return new AuthResultImpl(this, AuthResult.PASS, user);
		} else {
			User user = new VisitUser(this);
			return new AuthResultImpl(this, AuthResult.FAIL, user);
		}
	}

	public AuthResult authenticate(HttpServletRequest request, Map props) throws Exception {
		throw new UnsupportedOperationException();
	}

	public String getLoginURL(HttpServletRequest request, String returnUrl, String charset) {
		UserService userService = UserServiceFactory.getUserService();
		return userService.createLoginURL(returnUrl);
	}
	public String getLogoutURL(HttpServletRequest request, String returnUrl, String charset) {
		UserService userService = UserServiceFactory.getUserService();
		return userService.createLogoutURL(returnUrl);
	}
}
