/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.gae;
import java.util.*;
import javax.servlet.http.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;
import org.kotemaru.auth.*;
import org.kotemaru.util.*;
import com.google.appengine.api.datastore.*;

/**
*/

public class BigtableUserDB {
	public static final DatastoreServiceFactory DSF = new DatastoreServiceFactory();

	public static final String KIND = "_UserDB";
	// PKEY = email;
	public static final String ROLES = "roles";

	public static final Map<String, UserDef> cache = new HashMap<String, UserDef>();

	public BigtableUserDB() {
	}

	public static Entity newEntity(String userName) {
		Entity entity = new Entity(KIND, userName);
	  	entity.setProperty(ROLES, "");
		return entity;
	}

	public static void putEntity(Entity entity) {
		DatastoreService ds = DSF.getDatastoreService();
		ds.put(entity);
	}
	public static Entity getEntity(String userName) {
		DatastoreService ds = DSF.getDatastoreService();
		Query query = new Query(KIND);
		Key key = KeyFactory.createKey(KIND, userName);
		query.addFilter(Entity.KEY_RESERVED_PROPERTY, 
								Query.FilterOperator.EQUAL , key);
		PreparedQuery pq = ds.prepare(query);
		Entity entity = pq.asSingleEntity();
		if (entity == null) return null;
		return entity;
	}

	public static boolean delEntity(Entity entity) {
		DatastoreService ds = DSF.getDatastoreService();
		try {
			ds.delete(entity.getKey());
			return true;
		} catch (IllegalArgumentException e) {
			LOG.warn(e.toString());
			return false;
		}
	}
/*
	public UserDef getUserDef(String userName) {
		synchronized (cache) {
			UserDef userDef = cache.get(userName);
			if (userDef != null) return userDef;

			Entity entity = getEntity(userName);
			if (entity == null) return null;

			String[] roles = entity.getProperty(ROLES).split(",");
			HashSet roleSet = new HashSet();
			for (int i=0; i<roles.length; i++) roleSet.add(roles[i].trim());

			userDef = new UserDef(userName, null, roleSet);
			cache.put(userName, userDef);
			return userDef;
		}
	}
*/

	public UserDef getUserDef(String userName) {
		Entity entity = getEntity(userName);
		if (entity == null) return null;

		String[] roles = ((String)entity.getProperty(ROLES)).split(",");
		HashSet roleSet = new HashSet();
		for (int i=0; i<roles.length; i++) roleSet.add(roles[i].trim());

		return new UserDef(userName, null, roleSet);
	}

	private static Map<String, UserDef> load(URL url) throws IOException {
		InputStream in = url.openStream();
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(in));
			Map<String, UserDef> map = new HashMap<String, UserDef>();

			String line;
			while ((line = reader.readLine()) != null) {
				if (line.startsWith("#")) continue;

				String[] part = line.split(":");
				String[] roles = part[2].split(",");
				HashSet roleSet = new HashSet();
				for (int i=0; i<roles.length; i++) roleSet.add(roles[i].trim());

				UserDef userDef = new UserDef(part[0].trim(),
						HexUtil.decodeHexBytes(part[1].trim()), roleSet);
				map.put(part[0], userDef);
			}
			return map;
		} finally {
			in.close();
		}
	}

	static class UserDef {
		private final String name;
		private final byte[] pass;
		private final Set roles;

		public UserDef(String name, byte[] pass, Set roles) {
			this.name = name;
			this.pass = pass;
			this.roles = roles;
		}

		public String getName() {
			return name;
		}
		public boolean isMatchPasswd(byte[] md5pass) {
			if (pass.length != md5pass.length) return false;
			for (int i=0; i<pass.length; i++) {
				if (pass[i] != md5pass[i]) return false;
			}
			return true;
		}

		public Set getRoles() {
			return roles;
		}
	}

}
