/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.dummy;
import java.util.*;
import javax.servlet.http.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;
import org.kotemaru.auth.*;
import org.kotemaru.util.*;


/**
Ex:
class=org.kotemaru.auth.dummy.PAMImpl
loginUrl=/wsjs/login/login.html
*/

public class PAMImpl extends PAMBase  {
	public PAMImpl(Map props) throws IOException {
		super(props);
	}

	public String getName() {
		return "dummy";
	}

	public String getDescription() {
		return "This PAM depends on dummy.\n";
	}
	public IdProvider getIdProvider() {
		return new IdProviderImpl("dummy");
	}

	public AuthResult authForRequest(HttpServletRequest request) throws Exception {
		return new AuthResultImpl(this, AuthResult.MOOT, PAMFactory.getVisitUser());
	}
	public AuthResult authenticate(HttpServletRequest request, Map props) throws Exception {
		return authenticate(
			(String)props.get("user"),
			(String)props.get("pass")
		);
	}


	private AuthResult authenticate(String user, String pass) throws Exception {
		if (user == null || pass == null) {
			return new AuthResultImpl(this, AuthResult.MOOT, PAMFactory.getVisitUser());
		}

		if (user.equals(pass)) {
			User user0 = new UserImpl(this, PAMFactory.getRoleManager(), user);
			return new AuthResultImpl(this, AuthResult.PASS, user0);
		} else {
			return new AuthResultImpl(this, AuthResult.FAIL, PAMFactory.getVisitUser());
		}
	}


}
