/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth.cas;
import java.util.*;
import javax.servlet.http.*;
import org.kotemaru.auth.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.*;

/**
CAS用PAM。

Ex:
class=auth.cas.PAMImpl
casUrl=http://CAS.service/cas
loginUrl=http://localhost/login/login-cas.html
*/

public class PAMImpl extends PAMBase {
	private final String casUrl;
	private final IdProvider idProvider;

	public PAMImpl(Map props) {
		super(props);
		casUrl = (String)props.get("casUrl");
		idProvider = new IdProviderImpl(casUrl);
	}

	public String getName() {
		return "cas";
	}

	public String getDescription() {
		return "This PAM depends on CAS server.\n";
	}
	public IdProvider getIdProvider() {
		return idProvider;
	}

	public AuthResult authForRequest(HttpServletRequest request) throws Exception {
		return new AuthResultImpl(this, AuthResult.MOOT, PAMFactory.getVisitUser());
	}

	public String prepare(HttpServletRequest request, Map props) throws Exception {
		return casUrl+"?service="+URLEncoder.encode(getLoginUrl(), "UTF-8");
	}

	public AuthResult authenticate(HttpServletRequest request, Map props) throws Exception {
		String ticket = request.getParameter("ticket");
		if (ticket == null) {
			return new AuthResultImpl(this, AuthResult.MOOT, PAMFactory.getVisitUser());
		} else {
			String userName = validateCas(request, ticket);
			if (userName != null) {
				User user = new UserImpl(this, PAMFactory.getRoleManager(), userName);
				return new AuthResultImpl(this, AuthResult.PASS, user);
			} else {
				return new AuthResultImpl(this, AuthResult.FAIL, PAMFactory.getVisitUser());
			}
		}
	}
	private String validateCas(HttpServletRequest request, String ticket) throws Exception {
		String loc = casUrl	+ "/validate"
			+ "?service="	+ URLEncoder.encode(getLoginUrl(), "UTF-8")
			+ "&ticket=" + ticket;

		HttpClient client = new HttpClient(); // TODO: proxy
		HttpMethodBase method = new GetMethod(loc);
		try {
			int status = client.executeMethod(method);
			if(status / 100 != 2) return null;

			String body = method.getResponseBodyAsString();
			if (body.startsWith("no")) return null;
			String[] user = body.split("\n");
			return user[1];
		} finally {
			method.releaseConnection();
		}
	}



}
