/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth;
import java.util.Set;
import java.io.*;
import java.util.*;

/**
 * visitorユーザの実装。
 */
public  class VisitUser extends UserBase implements RoleManager {
	private final static IdProvider IdP = new IdProviderImpl("");

	public VisitUser(PAM pam) {
		super(pam, null, IdP, "");
	}
	public Map getAttributes() {
		return null;
	}
	public void setAttributes(Map attrs) {
		// nop.
	}

	/** 常に無効 */
	public final boolean isAdmin() {
		return false;
	}
	/** 常に無効 */
	public final boolean isGuest() {
		return false;
	}
	/** 常に有効 */
	public final boolean isVisitor(){
		return true;
	}
	/** visitor ロールのみ有効 */
	public final boolean hasRole(String role) {
		if (VISITOR.equals(role)) return true;
		return false;
	}

//-------------------------------------------------------
// for RoleManager
	public int getRoleState(User user, String role) {
		return DENY;
	}
	public Set getRoles(User user) {
		return null;
	}
	public Map getAttributes(User user) {
		throw new RuntimeException("TODO: unsupported");
	}
	public void setAttributes(User user, Map attrs) {
		throw new RuntimeException("TODO: unsupported");
	}
	public User getUser(PAM pam, IdProvider idp, String name, String uid, boolean isGenerate) {
		throw new RuntimeException("TODO: unsupported");
	}
	public void putUser(User user){
		throw new RuntimeException("TODO: unsupported");
	}

}




