/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth;
import java.util.Map;

/**
 * ユーザのインターフェース。
 */
public interface User extends java.io.Serializable  {

	public static final String GUEST = "guest";
	public static final String ADMIN = "admin";
	public static final String USERS = "users";
	public static final String VISITOR = "visitor";

	/**
	 * ユーザを認証したPAMを返す。
	 * @return PAM
	 */
	public PAM getPAM();

	/**
	 * ユーザを認証したプロバイダ情報を返す。
	 * @return IdProvider
	 */
	public IdProvider getIdProvider();

	/**
	 * ユーザのRoleManagerを返す。
	 * @return RoleManager
	 */
	public RoleManager getRoleManager();

	/**
	 * ユーザ名を返す。
	 * @return ユーザ名
	 */
	public String getName();

	/**
	 * ユーザIDを返す。
	 * @return ユーザID
	 */
	public String getId();

	public Map getAttributes();
	public void setAttributes(Map attrs);
	public boolean isRegistered();

	/**
	 * admin ロールを持っているか否かを返す。
	 * @return admin ならtrue。
	 */
	public boolean isAdmin();
	/**
	 * guest ロールを持っているか否かを返す。
	 * @return guest ならtrue。
	 */
	public boolean isGuest();
	/**
	 * visitor ロールを持っているか否かを返す。
	 * @return visitor ならtrue。
	 */
	public boolean isVisitor();
	/**
	 * ロールを持っているか否かを返す。
	 * @param role ロール名
	 * @return ロールを持っているならtrue。
	 */
	public boolean hasRole(String role);
}




