/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth;
import javax.servlet.http.*;
import javax.servlet.*;
import java.io.*;
import java.util.*;

/**
 * ロール管理のインターフェース。
 */
public interface RoleManager extends Serializable  {
	public static final int MOOT  = 0x0;
	public static final int ALLOW = 0x1;
	public static final int DENY  = 0x2;
	/**
	 * ユーザのロールの許可状態を返す。
	 * @param user ユーザ
	 * @param role ロール名
	 * @return MOOT=不明(不許可)。ALLOW=許可。DENY=禁止。
	 */
	public int getRoleState(User user, String role);

	/**
	 * ユーザの持っているロールを全て返す。
	 * <li>許可状態がALLOWとなる物だけのコレクション。
	 * @param user ユーザ
	 * @return ロールのコレクション。取得できない場合、null。
	 */
	public Set getRoles(User user);

}
