/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth;
import java.util.*;
import javax.servlet.http.*;
import org.kotemaru.auth.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.servlet.*;
import java.io.*;
import java.net.*;
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.*;


public abstract class PAMBase implements PAM {
	protected static final String RETURN_URL = "returnUrl";
	protected static final String LOGIN_URL = "loginUrl";
	protected static final String CHARSET = "charset";
	private final String loginUrl;

	public PAMBase(Map props) {
		loginUrl = (String) props.get(LOGIN_URL);
	}
	public boolean isServletAuth() {
		return false;
	}

	public String prepare(HttpServletRequest request, Map props) 
			throws Exception
	{
		return null;
	}

	public AuthResult authForRequest(HttpServletRequest request) throws Exception {
		return new AuthResultImpl(this, AuthResult.MOOT, PAMFactory.getVisitUser());
	}

	protected String getLoginUrl() {
		return loginUrl;
	}

	public String getLoginURL(HttpServletRequest request, String returnUrl, String charset) {
		try {
			return getLoginUrl()
				+"?"+RETURN_URL+"=" + URLEncoder.encode(returnUrl, charset)
				+"&"+CHARSET+"=" + charset;
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	public String getLogoutURL(HttpServletRequest request, String returnUrl, String charset) {
		return null;
	}

}
