/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth;
import javax.servlet.http.*;
import javax.servlet.*;
import java.io.*;
import java.util.*;

/**
 * 複合ロール管理
 */
public class MultiRoleManager implements RoleManager {
	private RoleManager[] managers;

	public MultiRoleManager(RoleManager[] rms) {
		managers = rms;
	}

	/**
	 * {@inheritDoc}
	 * <li>全てのRoleManagerのhasRole()の or の結果。
	 * <li>DENYが１つでもあればDENYとなる。
	 */
	public int getRoleState(User user, String role) {
		int state = MOOT;
		for (int i=0; i<managers.length; i++) {
			state = state | managers[i].getRoleState(user, role);
		}

		if ((state & DENY) == DENY) return DENY;
		return state & ALLOW;
	}

	/**
	 * {@inheritDoc}
	 * <li>全てのRoleManagerのgetRoles()をマージする。
	 * <li>getRoleState()でDENYとなるものは排除する。
	 * <li>一つでも戻り値がnullの物があればnullを返す。
	 */
	public Set getRoles(User user) {
		HashSet roles = new HashSet();
		for (int i=0; i<managers.length; i++) {
			Set roles0 = managers[i].getRoles(user);
			if (roles0 == null) return null;
			roles.addAll(roles0);
		}

		Iterator ite = roles.iterator();
		while(ite.hasNext()){
			String role = (String) ite.next();
			if (getRoleState(user, role) == DENY) {
				ite.remove();
			}
		}
		return roles;
	}

}
