/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth;
import javax.servlet.http.*;
import javax.servlet.*;
import java.io.*;
import java.util.*;
import org.mozilla.javascript.*;

/**
 * JavaScriptロール管理
 */
public class JSRoleManager implements RoleManager {
	private final Scriptable script;

	public JSRoleManager(Scriptable params) {
		this.script = params;
	}

	public int getRoleState(User user, String role) {
		Context cx = Context.enter();
		try {
			Scriptable scope = cx.initStandardObjects();
			Function func =	(Function) script.get("getRoleState", scope);
			if (func == null) {
				return getRoles(user).contains(role) ? ALLOW : MOOT;
			}
			Object obj = func.call(cx, scope, func, new Object[]{user, role});
			Integer state = (Integer) cx.jsToJava(obj, Integer.class);
			return state.intValue();
		} finally {
			Context.exit();
		}
	}

	public Set getRoles(User user) {
		Context cx = Context.enter();
		try {
			Scriptable scope = cx.initStandardObjects();
			Function func =	(Function) script.get("getRoles", scope);
			Object obj = func.call(cx, scope, func, new Object[]{user});

			if (obj == null || obj instanceof org.mozilla.javascript.Undefined) {
				return null;
			} else if (obj instanceof org.mozilla.javascript.NativeArray) {
				Scriptable ary = (Scriptable) obj;
				HashSet roles = new HashSet();
				for (int i=0; i<Integer.MAX_VALUE; i++) {
					Object val = ary.get(i, scope);
					if (val == ary.NOT_FOUND || val == Undefined.instance ) break;
					roles.add(val.toString());
				}
				return roles;
			} else if (obj instanceof org.mozilla.javascript.NativeJavaObject) {
				return (Set) ((Wrapper)obj).unwrap();
			}
			throw new RuntimeException("getRoles: Bad return value type:"
							+obj.getClass().getName());
		} finally {
			Context.exit();
		}
	}


}
