/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.auth;
import javax.servlet.http.*;


/**
 * 認証結果のインターフェース。
 */
public interface AuthResult  extends java.io.Serializable {
	/** 結果不明  */
	public int MOOT = 0;
	/** 認証成功  */
	public int PASS = 1;
	/** 認証失敗  */
	public int FAIL = 2;


	/**
	 * 認証結果の状態を返す。
	 * @return PASS,FAIL,MOOT のいずれか
	 */
	public int getStatus();
	/**
	 * 認証を行ったPAMインスタンスを返す。
	 * @return PAMインスタンス
	 */
	public PAM getPAM();
	/**
	 * 認証結果のユーザを返す。<ul>
	 * <li>認証失敗の場合には {@link VisitUser} を返す。
	 * </ul>
	 * @return ユーザ
	 */
	public User getUser();
}

