// layoutBorder

(function(JSCP){
var clazz = function(node) {
	this.node = node;
};
clazz.prototype = {
	NAME: "layoutBorder",
	isMatch: function(node, lowerCaseName) {
		return lowerCaseName == JSCP.NS+"layout"
			&& JSCP.getAttr(node,"type") == "border";
	},

	apply: function(node) {
		// nop. layout only.
	},

	activate: function(node) {
		var children = JSCP.getChildren(node, "*");
		var container = {};
		for (var i=0; i<children.length; i++) {
			var child = children[i];
			if (child.nodeType == 1) { // Element
				var pos = JSCP.getAttr(child, "position", "main");
				container[pos] = child;
			}
		}

		var hNode = container["header"];
		var fNode = container["footer"];
		var nNode = container["navigator"];
		var aNode = container["side-a"];
		var bNode = container["side-b"];
		var mNode = container["main"];

/*
x0    x1          x2      x3
┌────────────┐y0
│　　　　header  　　　　│  
├────────────┤y1
│　　　navigator　　 　　│  
├──┬─────┬───┤y2
│side│　　　　　│size-b│ 
│A 　│　main　　│　　　│  
│　　│　　　　　│　　　│  
├──┴─────┴───┤y3
│　　　footer　　　　　　│  
└────────────┘y4
*/
		node.offsetParent.style.position="relative";

		var max_h = parseInt(node.offsetParent.offsetHeight);
		var max_w = parseInt(node.offsetParent.offsetWidth);

		var head_h  = hNode ? parseInt(hNode.offsetHeight) : 0;
		var vani_h  = nNode ? parseInt(nNode.offsetHeight) : 0;
		var foot_h  = fNode ? parseInt(fNode.offsetHeight) : 0;
		var sidea_w = aNode ? parseInt(aNode.offsetWidth)  : 0;
		var sideb_w = bNode ? parseInt(bNode.offsetWidth)  : 0;

		var x0 = 0;
		var x1 = sidea_w;
		var x2 = max_w - sideb_w;
		var x3 = max_w;

		var y0 = 0;
		var y1 = head_h;
		var y2 = head_h+vani_h;
		var y3 = max_h-foot_h;
		var y4 = max_h;

		this.setRect(hNode, x0,y0,x3,y1);
		this.setRect(fNode, x0,y3,x3,y4);
		this.setRect(nNode, x0,y1,x3,y2);
		this.setRect(aNode, x0,y2,x1,y3);
		this.setRect(bNode, x2,y2,x3,y3);
		this.setRect(mNode, x1,y2,x2,y3);
	},

	setRect: function(node, x1, y1, x2 , y2) {
		if (node == null) return;
		node.style.position = "absolute";
		node.style.left   = x1+"px";
		node.style.top    = y1+"px";
		if (x2>=x1) node.style.width  = (x2-x1)+"px";
		if (y2>=y1) node.style.height = (y2-y1)+"px";
	}

};

return clazz;
})

