
function DataBase(dataSourceName) {
	if (dataSourceName == null) {
		this.connect = __ENV__.getDBConnection();
	} else {
		this.connect = __ENV__.getDBConnection(dataSourceName);
	}
	this.connect.setAutoCommit(false);
}

DataBase.transaction = function(dataSourceName, func){
	var db = new DataBase(dataSourceName);
	try {
		return func(db);
	} catch (e) {
		__ENV__.LOG.error(e);
		throw e;
	} finally {
		db.close();
	}
}

DataBase.prototype.createTable = function(name, cols){
	var st = this.connect.createStatement();
	try {
		var sql = "CREATE TABLE "+name+"(";
		for (var key in cols) {
			sql += key +" "+cols[key]+",";
		}
		sql = sql.replace(/,$/,")");
		__ENV__.LOG.info("DataBase:"+sql);
		st.execute(sql);
	} finally {
		st.close();
	}
}

DataBase.prototype.dropTable = function(name, isIgnoreError){
	var st = this.connect.createStatement();
	try {
		var sql = "DROP TABLE "+name;
		__ENV__.LOG.info("DataBase:"+sql);
		st.execute(sql);
	} catch(e) {
		if (!isIgnoreError) throw e;
		__ENV__.LOG.warn(e);
	} finally {
		st.close();
	}
}
DataBase.prototype.execute = function(sql, args){
	var st = this.connect.prepareStatement(sql,
		java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE,
		java.sql.ResultSet.CONCUR_UPDATABLE);
	__ENV__.LOG.info("DataBase:"+sql);
	try {
		if (args) {
			for (var i=0; i<args.length; i++) st.setObject(i+1, args[i]);
		}
		st.execute();
	} finally {
		st.close();
	}
}

DataBase.prototype.getTable = function(name, where, order){
	var sql = "SELECT * FROM "+name 
		+ this._sqlWhere(where)
		+ this._sqlOrder(order);
	__ENV__.LOG.debug("DataBase:"+sql);
	var st = this.connect.prepareStatement(sql,
			java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE,
			java.sql.ResultSet.CONCUR_UPDATABLE);
	try {
		var n = 1;
		for (var k in where) st.setObject(n++, where[k]);
		var rset = st.executeQuery();
		return new Table(st, rset);
	} finally {
		//st.close(); -> Table.close();
	}
}
DataBase.prototype._sqlWhere = function(props){
	if (props == null) return "";
	var where = "";
	for (var k in props) where += " AND "+ k +"=?";
	where = where.replace(/^[ ]AND/," WHERE");
	return where;
}
DataBase.prototype._sqlOrder = function(props){
	if (props == null) return "";
	var order = "";
	for (var k in props) order += ", "+k + " "+props[k];
	order = order.replace(/^,/," ORDER BY");
	return order;
}

DataBase.prototype.query = function(sql, args){
	__ENV__.LOG.debug(sql);
	var st = this.connect.prepareStatement(sql,
		java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE,
		java.sql.ResultSet.CONCUR_UPDATABLE);
	try {
		for (var i=0; i<args.length; i++) st.setObject(i+1, args[i]);
		var rset = st.executeQuery();
		return new Table(st, rset);
	} finally {
		//st.close(); -> Table.close();
	}
}

DataBase.prototype.table2json = function(name){
	return this.query2json("SELECT * FROM "+name);
}

DataBase.prototype.query2json = function(sql){
	var st = this.connect.createStatement();
	try {
		var rset = st.executeQuery(sql);
		var table = new Table(st, rset);
		var json = [];
		while (rset.next()) {
			json.push(table.getCurrentRow());
		}
		return json;
	} finally {
		st.close();
	}
}

DataBase.prototype.table2html = function(name){
	var table = this.getTable(name);
	var names = table.getColumnNames();
	var htable = <table border='1' cellspacing='0' />
	var th = <tr/>;
	for (var i=0; i<names.length; i++) {
		th.appendChild(<th>{names[i]}</th>);
	}
	htable.appendChild(th);
	while (table.next()) {
		var td = <tr/>
		for (var i=0; i<names.length; i++) {
			td.appendChild(<td>{table.rset.getObject(i+1)}</td>);
		}
		htable.appendChild(td);
	}
	table.close();
	return htable;
}

DataBase.prototype.appendRow = function(name, data){
	var table = this.getTable(name);
	table.rset.last();
	if (data instanceof Array) {
		for (var i=0; i<data.length; i++) {
			table.insertCurrentRow(data[i]);
		}
	} else {
		table.insertCurrentRow(data);
	}
	table.close();
}

DataBase.prototype.queryRow = function(name, where){
	var sql = "SELECT * FROM "+name + this._sqlWhere(where);
	__ENV__.LOG.debug(sql);
	var st = this.connect.prepareStatement(sql);
	try {
		var n = 1;
		for (var k in where) st.setObject(n++, where[k]);
		var rset = st.executeQuery();
		var table = new Table(st, rset);
		if (!table.next()) return null;
		return table.getCurrentRow();
	} finally {
		st.close();
	}
}

DataBase.prototype.updateRow = function(name, where, data){
	var cond = "";
	var vals = "";
	for (var k in where) cond = k +"=? AND ";
	for (var k in data) vals = k +"=?,";
	cond = cond.replace(/AND $/,"");
	vals = vals.replace(/,$/,"");

	var sql = "UPDATE "+name+" SET "+vals+" WHERE "+cond;
	__ENV__.LOG.debug(sql);
	var st = this.connect.prepareStatement(sql);
	try {
		var n = 1;
		for (var k in where) st.setObject(n++, where[k]);
		for (var k in data)  st.setObject(n++, data[k]);
		st.execute();
	} finally {
		st.close();
	}
}
DataBase.prototype.deleteRow = function(name, where){
	var cond = "";
	for (var k in where) cond = k +"=? AND ";
	cond = cond.replace(/AND $/,"");

	var sql = "DELETE FROM "+name+" WHERE "+cond;
	var st = this.connect.prepareStatement(sql);
	try {
		var n = 1;
		for (var k in where) st.setObject(n++, where[k]);
		st.execute();
	} finally {
		st.close();
	}
}


DataBase.prototype.close = function() {
	this.connect.commit();
	return this.connect.close();
}
DataBase.prototype.setAutoCommit = function(isAutoCommit) {
	return this.connect.setAutoCommit(isAutoCommit);
}
DataBase.prototype.commit = function() {
	return this.connect.commit();
}
DataBase.prototype.rollback = function() {
	return this.connect.rollback();
}

//--------------------------------------------------
function Table(st, rset) {
	this.statement = st;
	this.rset = rset;
}
Table.prototype.close = function() {
	return this.statement.close();
}

Table.prototype.getResultSet = function() {
	return rset;
}
Table.prototype.next = function() {
	return this.rset.next();
}
Table.prototype.last = function() {
	return this.rset.last();
}
Table.prototype.previous = function() {
	return this.rset.previous();
}
Table.prototype.absolute = function(row) {
	return this.rset.absolute(row);
}


Table.prototype.getColumnNames = function() {
	if (this.columnNames) return this.columnNames;
	var meta = this.rset.getMetaData();
	this.columnNames = [];
	for (var i=0; i<meta.getColumnCount(); i++) {
		this.columnNames.push(meta.getColumnName(i+1).toLowerCase());
	}
	return this.columnNames;
}


Table.prototype.getRow = function(row) {
	if (row && this.rset.absolute(row)) return null;
	return this.getCurrentRow();
}
Table.prototype.getCurrentRow = function() {
	var names = this.getColumnNames();
	var data = {};
	for (var i=0; i<names.length; i++) {
		var val = this.rset.getObject(i+1);
		if (val == null) {
			data[names[i]] = null;
		} else if (val instanceof java.lang.Number) {
			data[names[i]] = val.intValue();
		} else {
			data[names[i]] = ""+val.toString();
		}
	}
	return data;
}
Table.prototype.setRow = function(row, data) {
	if (data == null) throw "use setCurrentRow()";
	this.rset.absolute(row);
	this.setCurrentRow(data);
}
Table.prototype.setCurrentRow = function(data) {
	this.setCurrentColumns(data)
	this.rset.updateRow();
}
Table.prototype.setCurrentColumns = function(data) {
	var names = this.getColumnNames();
	for (var i=0; i<names.length; i++) {
		if (data[names[i]] != undefined) {
//TODO:大文字/小文字
			this.rset.updateObject(i+1, data[names[i]]);
		}
	}
}


Table.prototype.insertRow = function(row, data) {
	if (data == null) throw "use insertCurrentRow()";
	this.rset.absolute(row);
	this.rset.insertCurrentRow(data);
}
Table.prototype.insertCurrentRow = function(data) {
	this.rset.moveToInsertRow();
	this.setCurrentColumns(data)
	this.rset.insertRow();
	this.rset.moveToCurrentRow();
}
Table.prototype.deleteRow = function(row) {
	if (row && this.rset.absolute(row)) return null;
	return this.rset.deleteRow();
}
Table.prototype.deleteCurrentRow = function() {
	this.rset.deleteRow();
}





