/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheFactory;

public class CacheManager {
    protected static CacheManager instance = new CacheManager();
    private final Map caches = Collections.synchronizedMap(new HashMap());

    public static CacheManager getInstance() {
        return instance;
    }

    public Cache getCache(String string) {
        return (Cache)this.caches.get(string);
    }

    public void registerCache(String string, Cache cache) {
        this.caches.put(string, cache);
    }

    public CacheFactory getCacheFactory() throws CacheException {
        String string = this.getImplementationClassName(CacheFactory.class.getName());
        if (string == null) {
            throw new CacheException("No implementation of JCache can be found on the classpath");
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = this.getClass().getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new CacheException("Could not find class name: " + string);
            }
        }
        try {
            return (CacheFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new CacheException("Could not instantiate instance of: " + string + ". Reason: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getImplementationClassName(String string) {
        Object object;
        try {
            object = System.getProperty(string);
            if (object != null && ((String)object).length() > 0) {
                return object;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = this.getResourceAsStream("META-INF/services/" + string);
            if (object == null) return null;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            try {
                String string2 = bufferedReader.readLine();
                if (string2 == null) return null;
                if ((string2 = string2.trim()).length() <= 0) return null;
                String string3 = string2;
                return string3;
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected InputStream getResourceAsStream(String string) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        }
        return inputStream;
    }
}

