/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.storage.speckle.jdbc.internal.Util;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpeckleUrl {
    public static final String[] URL_PREFIXES = new String[]{"jdbc:google:rdbms:", "jdbc:google:speckle:"};
    private static final Set<String> LOCAL_PROPERTIES = Collections.unmodifiableSet(Util.newHashSet((Comparable[])new String[]{"authToken", "oauthToken"}));
    private final String originalUrl;
    private final Properties originalInfo;
    private final Map<String, String> properties;
    private final Map<String, String> localProperties;

    public static SpeckleUrl create(String url, Properties info) {
        if (!SpeckleUrl.acceptsUrl(url)) {
            throw new IllegalArgumentException(MessageFormat.format("URL is not in the correct format: {0}", url));
        }
        HashMap<String, String> properties = Util.newHashMap();
        String rest = SpeckleUrl.stripProtocol(url);
        int index = rest.indexOf(63);
        if (index != -1) {
            SpeckleUrl.parseProperties(rest.substring(index + 1), properties);
            rest = rest.substring(0, index);
        }
        if ((index = rest.indexOf(35)) != -1) {
            SpeckleUrl.parseInstanceDatabase(rest.substring(index + 1), properties);
            rest = rest.substring(0, index);
            if (rest.startsWith("//")) {
                rest = rest.substring("//".length());
            }
            SpeckleUrl.parseServer(rest, properties);
        } else {
            if (rest.startsWith("//")) {
                rest = rest.substring("//".length());
            }
            SpeckleUrl.parseInstanceDatabase(rest.substring(index + 1), properties);
        }
        if (info == null) {
            info = new Properties();
        }
        HashMap<String, String> localProperties = Util.newHashMap();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            if (LOCAL_PROPERTIES.contains(entry.getKey())) {
                localProperties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                continue;
            }
            properties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        if (!properties.containsKey("instance")) {
            throw new IllegalArgumentException(MessageFormat.format("URL is not in the correct format: {0}", url));
        }
        return new SpeckleUrl(url, info, properties, localProperties);
    }

    public static SpeckleUrl createFromMap(String url, Map<String, String> properties) {
        Properties info = new Properties();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            info.put(e.getKey(), e.getValue());
        }
        return SpeckleUrl.create(url, info);
    }

    public static boolean acceptsUrl(String url) {
        if (url == null) {
            return false;
        }
        for (String prefix : URL_PREFIXES) {
            if (!url.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static String stripProtocol(String url) {
        for (String prefix : URL_PREFIXES) {
            if (!url.startsWith(prefix)) continue;
            return url.substring(prefix.length());
        }
        throw new IllegalArgumentException(url + " does not start with a valid protocol.");
    }

    private static void parseServer(String s, Map<String, String> properties) {
        properties.put("server", s);
    }

    private static void parseInstanceDatabase(String s, Map<String, String> properties) {
        int index = s.indexOf(47);
        if (index != -1) {
            String[] parts = s.split("\\/");
            SpeckleUrl.putIfNotEmpty(properties, "instance", parts[0]);
            SpeckleUrl.putIfNotEmpty(properties, "database", parts[1]);
        } else {
            SpeckleUrl.putIfNotEmpty(properties, "instance", s);
        }
    }

    private static void putIfNotEmpty(Map<String, String> properties, String key, String value) {
        if (!Strings.isNullOrEmpty(value)) {
            properties.put(key, value);
        }
    }

    private static void parseProperties(String s, Map<String, String> properties) {
        String[] parts;
        for (String part : parts = s.split("\\&")) {
            String[] kv = part.split("\\=");
            properties.put(kv[0], kv[1]);
        }
    }

    private SpeckleUrl(String originalUrl, Properties info, Map<String, String> properties, Map<String, String> localProperties) {
        this.properties = Collections.unmodifiableMap(properties);
        this.originalUrl = originalUrl;
        this.originalInfo = info;
        this.localProperties = localProperties;
    }

    public String getInstance() {
        return this.properties.get("instance");
    }

    public String getServer() {
        return this.properties.get("server");
    }

    public String getDatabase() {
        return this.properties.get("database");
    }

    public String getUser() {
        return this.properties.get("user");
    }

    public String getPassword() {
        return this.properties.get("password");
    }

    public Integer getConnectTimeoutSeconds() {
        return this.getInteger("connectTimeoutSeconds");
    }

    public Integer getQueryTimeoutSeconds() {
        return this.getInteger("queryTimeoutSeconds");
    }

    public String getOAuthToken() {
        return this.localProperties.get("oauthToken");
    }

    public String getLegacyAuthToken() {
        return this.localProperties.get("authToken");
    }

    Integer getInteger(String propertyName) {
        String value = this.properties.get(propertyName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getLocalProperty(String key) {
        return this.localProperties.get(key);
    }

    public boolean hasLocalProperty(String key) {
        return this.localProperties.containsKey(key);
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public Properties getOriginalInfo() {
        return this.originalInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpeckleUrl)) {
            return false;
        }
        SpeckleUrl that = (SpeckleUrl)obj;
        return ((Object)this.properties).equals(that.properties);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    public String toString() {
        return this.properties.toString();
    }
}

