/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.protos.speckle.Client;
import com.google.protos.speckle.sql.Sql;
import com.google.storage.speckle.jdbc.internal.AbstractSpeckleClient;
import com.google.storage.speckle.jdbc.internal.SpeckleRpc;
import com.google.storage.speckle.jdbc.internal.SpeckleRpcOptions;
import com.google.storage.speckle.jdbc.internal.SpeckleUrl;
import com.google.storage.speckle.jdbc.internal.TypedValue;
import com.google.storage.speckle.jdbc.internal.Util;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeckleProtoClient
extends AbstractSpeckleClient {
    private static final Logger LOG = Logger.getLogger(SpeckleProtoClient.class.getName());
    private final SpeckleRpc stub;

    public SpeckleProtoClient(String speckleInstance, SpeckleRpc stub) {
        super(speckleInstance);
        this.stub = Util.checkNotNull(stub, "stub can not be null");
        LOG.log(Level.FINE, "Created stubby client for instance: {0}", speckleInstance);
    }

    @Override
    public Sql.OpenConnectionResponse openConnection(SpeckleRpcOptions options, SpeckleUrl url) throws SQLException {
        LOG.log(Level.FINE, "Executing Connect: {0} at {1}/{2}", new Object[]{url.getUser(), url.getInstance(), url.getDatabase()});
        Sql.OpenConnectionRequest request = this.createConnectRequest(url);
        Sql.OpenConnectionResponse response = this.stub.openConnection(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }

    @Override
    public Sql.CloseConnectionResponse closeConnection(SpeckleRpcOptions options, ByteString connectionId) throws SQLException {
        LOG.log(Level.FINE, "Executing Release: {0}", connectionId);
        Sql.CloseConnectionRequest request = this.createReleaseRequest(connectionId);
        Sql.CloseConnectionResponse response = this.stub.closeConnection(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }

    @Override
    public Sql.ExecResponse executeSql(SpeckleRpcOptions options, ByteString connectionId, String sql) throws SQLException {
        return this.executeSql(options, connectionId, sql, Collections.<TypedValue>emptyList());
    }

    @Override
    public Sql.ExecResponse executeSql(SpeckleRpcOptions options, ByteString connectionId, String sql, List<TypedValue> bindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", sql);
        Sql.ExecRequest request = this.createExecRequest(options, connectionId, sql, bindParameters);
        Sql.ExecResponse response = this.stub.exec(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public Sql.ExecResponse executeNext(SpeckleRpcOptions options, ByteString connectionId, long statementId) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", statementId);
        Sql.ExecRequest request = this.createExecNextRequest(options, connectionId, statementId);
        Sql.ExecResponse response = this.stub.exec(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public Sql.ExecOpResponse executeOperation(SpeckleRpcOptions options, ByteString connectionId, Client.OpProto op) throws SQLException {
        LOG.log(Level.FINE, "Executing Operation: {0}", op.getType().name());
        Sql.ExecOpRequest request = this.createExecOpRequest(connectionId, op);
        Sql.ExecOpResponse response = this.stub.execOp(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public final Sql.MetadataResponse getMetadata(SpeckleRpcOptions options, ByteString connectionId, Client.MetadataType metadataType, List<TypedValue> bindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing metadata request for type: {0}", metadataType);
        Sql.MetadataRequest request = this.createMetadataRequest(connectionId, metadataType, bindParameters);
        Sql.MetadataResponse response = this.stub.getMetadata(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }
}

