/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.protos.speckle.Client;
import com.google.protos.speckle.sql.Sql;
import com.google.storage.speckle.jdbc.SpeckleDatabaseMetaData;
import com.google.storage.speckle.jdbc.SpecklePreparedStatement;
import com.google.storage.speckle.jdbc.SpeckleStatement;
import com.google.storage.speckle.jdbc.internal.ConnectionOperationHelper;
import com.google.storage.speckle.jdbc.internal.Exceptions;
import com.google.storage.speckle.jdbc.internal.SpeckleClient;
import com.google.storage.speckle.jdbc.internal.SpeckleRpcOptions;
import com.google.storage.speckle.jdbc.internal.SpeckleUrl;
import com.google.storage.speckle.jdbc.internal.SpeckleWrapper;
import com.google.storage.speckle.jdbc.internal.TypedValue;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpeckleConnection
extends SpeckleWrapper
implements Connection {
    private static final Logger LOG = Logger.getLogger(SpeckleConnection.class.getName());
    private final SpeckleClient client;
    private final ByteString connectionId;
    private final SpeckleUrl url;
    private boolean autoCommit = true;
    private String catalog;
    private boolean open;
    private int transactionIsolationLevel = 8;

    public SpeckleConnection(SpeckleUrl url, SpeckleClient client, ByteString connectionId) {
        this.client = client;
        this.connectionId = connectionId;
        this.url = url;
        this.open = true;
        String database = url.getDatabase();
        if (database != null) {
            this.catalog = database;
        }
        LOG.finest("SpeckleConnection: " + url);
    }

    @Override
    public void close() throws SQLException {
        if (!this.open) {
            return;
        }
        this.open = false;
        Sql.CloseConnectionResponse response = this.client.closeConnection(SpeckleRpcOptions.defaultOptions(), this.connectionId);
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
    }

    @Override
    public void commit() throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.commit());
    }

    @Override
    public SpeckleStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.getHoldability());
    }

    @Override
    public SpeckleStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public SpeckleStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfNotOpen();
        return new SpeckleStatement(resultSetType, resultSetConcurrency, resultSetHoldability, this, this.url);
    }

    @Override
    public SpecklePreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfNotOpen();
        return new SpecklePreparedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, this, this.url);
    }

    @Override
    public SpecklePreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public SpecklePreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.throwIfNotOpen();
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.throwIfNotOpen();
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.setCatalog(catalog));
        this.catalog = catalog;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfNotOpen();
        return 2;
    }

    @Override
    public SpeckleDatabaseMetaData getMetaData() throws SQLException {
        this.throwIfNotOpen();
        Sql.MetadataResponse response = this.getMetadata(SpeckleRpcOptions.defaultOptions(), Client.MetadataType.METADATATYPE_DATABASE_METADATA_BASIC, Collections.<TypedValue>emptyList());
        return new SpeckleDatabaseMetaData(response.getJdbcDatabaseMetadata(), this, this.url);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.throwIfNotOpen();
        return this.transactionIsolationLevel;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public void rollback() throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.rollback());
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.rollback(savepoint.getSavepointName()));
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.autoCommit(autoCommit));
        this.autoCommit = autoCommit;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfNotOpen();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.throwIfNotOpen();
        return this.url.getOriginalInfo().getProperty(name);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.throwIfNotOpen();
        return false;
    }

    @Override
    public boolean isValid(int timeout) {
        return this.open;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.throwIfNotOpen();
        Sql.ExecOpResponse response = this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.nativeSQL(sql));
        return response.getNativeSql();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public SpecklePreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        SpecklePreparedStatement stmt = this.prepareStatement(sql);
        stmt.setIncludeExportedKeys(autoGeneratedKeys == 1);
        return stmt;
    }

    @Override
    public SpecklePreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        SpecklePreparedStatement stmt = this.prepareStatement(sql);
        stmt.setIncludeExportedKeys(true);
        stmt.setGeneratedColumnIndices(columnIndexes);
        return stmt;
    }

    @Override
    public SpecklePreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        SpecklePreparedStatement stmt = this.prepareStatement(sql);
        stmt.setIncludeExportedKeys(true);
        stmt.setGeneratedColumnNames(columnNames);
        return stmt;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (!this.open) {
            throw Exceptions.newClientInfoConnectionClosedException();
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (!this.open) {
            throw Exceptions.newClientInfoConnectionClosedException();
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.readOnly(readOnly));
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.throwIfNotOpen();
        Sql.ExecOpResponse response = this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.savePoint(name));
        return ConnectionOperationHelper.asJdbcSavePoint(response.getSavepoint());
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SpeckleRpcOptions.defaultOptions(), ConnectionOperationHelper.transactionIsolation(level));
        this.transactionIsolationLevel = level;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    Sql.ExecResponse executeSql(SpeckleRpcOptions options, String sql) throws SQLException {
        Sql.ExecResponse response = this.client.executeSql(options, this.connectionId, sql);
        if (response.getResult().hasSqlException()) {
            throw Exceptions.newSqlException(response.getResult().getSqlException());
        }
        return response;
    }

    Sql.ExecResponse executeSql(SpeckleRpcOptions options, String sql, List<TypedValue> bindParameters) throws SQLException {
        Sql.ExecResponse response = this.client.executeSql(options, this.connectionId, sql, bindParameters);
        if (response.getResult().hasSqlException()) {
            throw Exceptions.newSqlException(response.getResult().getSqlException());
        }
        return response;
    }

    Sql.ExecResponse executeNext(SpeckleRpcOptions options, long statementId) throws SQLException {
        Sql.ExecResponse response = this.client.executeNext(options, this.connectionId, statementId);
        if (response.getResult().hasSqlException()) {
            throw Exceptions.newSqlException(response.getResult().getSqlException());
        }
        return response;
    }

    Sql.ExecOpResponse executeOp(SpeckleRpcOptions options, Client.OpProto op) throws SQLException {
        Sql.ExecOpResponse response = this.client.executeOperation(options, this.connectionId, op);
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
        return response;
    }

    Sql.MetadataResponse getMetadata(SpeckleRpcOptions options, Client.MetadataType metadataType, List<TypedValue> bindParameters) throws SQLException {
        Sql.MetadataResponse response = this.client.getMetadata(options, this.connectionId, metadataType, bindParameters);
        if (response.getResult().hasSqlException()) {
            throw Exceptions.newSqlException(response.getResult().getSqlException());
        }
        return response;
    }

    String getUrl() {
        return this.url.getOriginalUrl();
    }

    private void throwIfNotOpen() throws SQLException {
        if (!this.open) {
            throw Exceptions.newConnectionClosedException();
        }
    }
}

