/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AbstractLinkedIterator;
import com.google.appengine.repackaged.com.google.common.collect.Cut;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteType;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.collect.Range;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@GoogleInternal
public final class DiscreteRange<C extends Comparable>
extends Range<C> {
    private final DiscreteType<C> typeDescriptor;

    DiscreteRange(Cut<C> lowerBound, Cut<C> upperBound, DiscreteType<C> typeDescriptor) {
        super(lowerBound, upperBound);
        this.typeDescriptor = Preconditions.checkNotNull(typeDescriptor);
    }

    @Override
    DiscreteRange<C> create(Cut<C> lower, Cut<C> upper) {
        return new DiscreteRange<C>(lower, upper, this.typeDescriptor);
    }

    @Override
    public DiscreteRange<C> intersection(Range<C> other) {
        return (DiscreteRange)super.intersection(other);
    }

    @Override
    public DiscreteRange<C> span(Range<C> other) {
        return (DiscreteRange)super.span(other);
    }

    public DiscreteRange<C> canonical() {
        Cut<C> lower = this.lowerBound.canonical(this.typeDescriptor);
        Cut<C> upper = this.upperBound.canonical(this.typeDescriptor);
        return lower == this.lowerBound && upper == this.upperBound ? this : this.create((Cut)lower, (Cut)upper);
    }

    public SortedSet<C> asSet() {
        DiscreteRange<C> canonical = this.canonical();
        Preconditions.checkState(canonical.hasLowerBound(), "cannot view " + this + " as a Set because it has no least value");
        return canonical.isEmpty() ? ImmutableSortedSet.of() : new DiscreteRangeAsSet<C>(canonical);
    }

    private C greatestValue() {
        try {
            return this.upperBound.greatestValueBelow(this.typeDescriptor);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private static int compareOrThrow(Comparable left, Comparable right) {
        return left.compareTo(right);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DiscreteRangeAsSet<C extends Comparable>
    extends AbstractSet<C>
    implements SortedSet<C> {
        final DiscreteRange<C> range;

        DiscreteRangeAsSet(DiscreteRange<C> range) {
            this.range = range;
        }

        @Override
        public int size() {
            Comparable last = ((DiscreteRange)this.range).greatestValue();
            if (last == null) {
                return Integer.MAX_VALUE;
            }
            long distance = ((DiscreteRange)this.range).typeDescriptor.distance(this.first(), last);
            if (distance >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)distance + 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object value) {
            if (value == null) {
                return false;
            }
            try {
                Comparable c = (Comparable)value;
                return this.range.contains(c);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean containsAll(Collection<?> values) {
            try {
                Collection<?> cs = values;
                return this.range.containsAll(cs);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<C> iterator() {
            return new AbstractLinkedIterator<C>((Comparable)this.first()){
                final C last;
                {
                    this.last = DiscreteRangeAsSet.this.range.greatestValue();
                }

                @Override
                protected C computeNext(C previous) {
                    return DiscreteRangeAsSet.equalsOrThrow(previous, this.last) ? null : (Object)DiscreteRangeAsSet.this.range.typeDescriptor.next(previous);
                }
            };
        }

        static boolean equalsOrThrow(Comparable left, @Nullable Comparable right) {
            return right != null && DiscreteRange.compareOrThrow(left, right) == 0;
        }

        @Override
        public Comparator<? super C> comparator() {
            return Ordering.natural();
        }

        @Override
        public SortedSet<C> subSet(C fromElement, C toElement) {
            Preconditions.checkArgument(DiscreteRange.compareOrThrow(fromElement, toElement) <= 0);
            Cut lower = Ordering.natural().max(this.range.lowerBound, new Cut.BelowValue<C>(fromElement));
            Cut upper = Ordering.natural().min(this.range.upperBound, new Cut.BelowValue<C>(toElement));
            return this.createSet(lower, upper);
        }

        @Override
        public SortedSet<C> headSet(C toElement) {
            Cut upper = Ordering.natural().min(this.range.upperBound, new Cut.BelowValue<C>(toElement));
            return this.createSet(this.range.lowerBound, upper);
        }

        @Override
        public SortedSet<C> tailSet(C fromElement) {
            Cut lower = Ordering.natural().max(this.range.lowerBound, new Cut.BelowValue<C>(fromElement));
            return this.createSet(lower, this.range.upperBound);
        }

        private SortedSet<C> createSet(Cut<C> lower, Cut<C> upper) {
            if (lower.compareTo(upper) >= 0) {
                return ImmutableSortedSet.of();
            }
            return new DiscreteRangeAsSet<C>(this.range.create((Cut)lower, (Cut)upper));
        }

        @Override
        public C first() {
            return this.range.lowerBound.endpoint();
        }

        @Override
        public C last() {
            Comparable last = ((DiscreteRange)this.range).greatestValue();
            if (last == null) {
                throw new IllegalStateException();
            }
            return (C)last;
        }

        @Override
        public String toString() {
            return "{" + this.size() + " values in the range " + this.range + "}";
        }
    }
}

