/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Equivalence;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AsynchronousComputationException;
import com.google.appengine.repackaged.com.google.common.collect.ComputationException;
import com.google.appengine.repackaged.com.google.common.collect.CustomConcurrentHashMap;
import com.google.appengine.repackaged.com.google.common.collect.MapEvictionListener;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComputingConcurrentHashMap<K, V>
extends CustomConcurrentHashMap<K, V>
implements MapMaker.Cache<K, V> {
    final Function<? super K, ? extends V> computingFunction;
    private static final long serialVersionUID = 2L;

    ComputingConcurrentHashMap(MapMaker builder, Function<? super K, ? extends V> computingFunction) {
        super(builder);
        this.computingFunction = Preconditions.checkNotNull(computingFunction);
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this;
    }

    @Override
    CustomConcurrentHashMap.Segment createSegment(int initialCapacity, int maxSegmentSize) {
        return new ComputingSegment(initialCapacity, maxSegmentSize);
    }

    @Override
    ComputingSegment segmentFor(int hash) {
        return (ComputingSegment)super.segmentFor(hash);
    }

    @Override
    public V apply(K key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).compute(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setValueReference(CustomConcurrentHashMap.ReferenceEntry<K, V> entry, CustomConcurrentHashMap.ValueReference<K, V> valueReference) {
        boolean notifyOthers = entry.getValueReference() == UNSET;
        entry.setValueReference(valueReference);
        if (notifyOthers) {
            CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry = entry;
            synchronized (referenceEntry) {
                entry.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitForValue(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) throws InterruptedException {
        CustomConcurrentHashMap.ValueReference<K, V> valueReference = entry.getValueReference();
        if (valueReference == UNSET) {
            CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry = entry;
            synchronized (referenceEntry) {
                while ((valueReference = entry.getValueReference()) == UNSET) {
                    entry.wait();
                }
            }
        }
        return valueReference.waitForValue();
    }

    @Override
    CustomConcurrentHashMap.ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap.ReferenceEntry<K, V> original, CustomConcurrentHashMap.ReferenceEntry<K, V> newNext) {
        CustomConcurrentHashMap.ReferenceEntry<K, V> newEntry = this.entryFactory.copyEntry(this, original, newNext);
        CustomConcurrentHashMap.ValueReference<K, V> valueReference = original.getValueReference();
        if (valueReference == UNSET) {
            newEntry.setValueReference(new FutureValueReference(original, newEntry));
        } else {
            newEntry.setValueReference(valueReference.copyFor(newEntry));
        }
        return newEntry;
    }

    @Override
    Object writeReplace() {
        return new ComputingSerializationProxy<K, V>(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expireAfterWriteNanos, this.expireAfterAccessNanos, this.maximumSize, this.concurrencyLevel, this.evictionListener, this, this.computingFunction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComputingSerializationProxy<K, V>
    extends CustomConcurrentHashMap.AbstractSerializationProxy<K, V> {
        final Function<? super K, ? extends V> computingFunction;
        transient MapMaker.Cache<K, V> cache;
        private static final long serialVersionUID = 2L;

        ComputingSerializationProxy(CustomConcurrentHashMap.Strength keyStrength, CustomConcurrentHashMap.Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, int maximumSize, int concurrencyLevel, MapEvictionListener<? super K, ? super V> evictionListener, ConcurrentMap<K, V> delegate, Function<? super K, ? extends V> computingFunction) {
            super(keyStrength, valueStrength, keyEquivalence, valueEquivalence, expireAfterWriteNanos, expireAfterAccessNanos, maximumSize, concurrencyLevel, evictionListener, delegate);
            this.computingFunction = computingFunction;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            this.writeMapTo(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(in);
            this.cache = mapMaker.makeCache(this.computingFunction);
            this.delegate = this.cache.asMap();
            this.readEntries(in);
        }

        Object readResolve() {
            return this.cache;
        }

        public ConcurrentMap<K, V> asMap() {
            return this.delegate;
        }

        public V apply(@Nullable K from) {
            return (V)this.cache.apply(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FutureValueReference
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final CustomConcurrentHashMap.ReferenceEntry<K, V> original;
        final CustomConcurrentHashMap.ReferenceEntry<K, V> newEntry;

        FutureValueReference(CustomConcurrentHashMap.ReferenceEntry<K, V> original, CustomConcurrentHashMap.ReferenceEntry<K, V> newEntry) {
            this.original = original;
            this.newEntry = newEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() {
            boolean success = false;
            try {
                Object value = this.original.getValueReference().get();
                success = true;
                Object v = value;
                return v;
            }
            finally {
                if (!success) {
                    this.removeEntry();
                }
            }
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return new FutureValueReference(this.original, entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V waitForValue() throws InterruptedException {
            boolean success = false;
            try {
                Object value = ComputingConcurrentHashMap.this.waitForValue(this.original);
                success = true;
                Object v = value;
                return v;
            }
            finally {
                if (!success) {
                    this.removeEntry();
                }
            }
        }

        @Override
        public void clear() {
            this.original.getValueReference().clear();
        }

        void removeEntry() {
            ComputingConcurrentHashMap.this.removeEntry(this.newEntry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComputationExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final Throwable t;

        ComputationExceptionReference(Throwable t) {
            this.t = t;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public V waitForValue() {
            throw new AsynchronousComputationException(this.t);
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullPointerExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final String message;

        NullPointerExceptionReference(String message) {
            this.message = message;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public V waitForValue() {
            throw new NullPointerException(this.message);
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComputingSegment
    extends CustomConcurrentHashMap.Segment {
        ComputingSegment(int initialCapacity, int maxSegmentSize) {
            super(ComputingConcurrentHashMap.this, initialCapacity, maxSegmentSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V compute(K key, int hash) {
            block12: while (true) {
                CustomConcurrentHashMap.ReferenceEntry entry;
                if ((entry = this.getEntry(key, hash)) == null) {
                    boolean created = false;
                    this.lock();
                    try {
                        if (ComputingConcurrentHashMap.this.expires()) {
                            this.expireEntries();
                        }
                        if ((entry = this.getEntry(key, hash)) == null) {
                            created = true;
                            int newCount = this.count + 1;
                            if (ComputingConcurrentHashMap.this.evictsBySize() && newCount > this.maxSegmentSize) {
                                this.evictEntry();
                                newCount = this.count + 1;
                            } else if (newCount > this.threshold) {
                                this.expand();
                            }
                            AtomicReferenceArray table = this.table;
                            int index = hash & table.length() - 1;
                            CustomConcurrentHashMap.ReferenceEntry first = (CustomConcurrentHashMap.ReferenceEntry)table.get(index);
                            ++this.modCount;
                            entry = ComputingConcurrentHashMap.this.entryFactory.newEntry(ComputingConcurrentHashMap.this, key, hash, first);
                            table.set(index, entry);
                            this.count = newCount;
                        }
                    }
                    finally {
                        this.unlock();
                    }
                    if (created) {
                        boolean success = false;
                        try {
                            Object value = this.compute(key, entry);
                            Preconditions.checkNotNull(value, "compute() returned null unexpectedly");
                            success = true;
                            Object v = value;
                            return v;
                        }
                        finally {
                            if (!success) {
                                this.removeEntry(entry, hash);
                            }
                        }
                    }
                }
                boolean interrupted = false;
                while (true) {
                    try {
                        Object value = ComputingConcurrentHashMap.this.waitForValue(entry);
                        if (value == null) {
                            this.removeEntry(entry, hash);
                            continue block12;
                        }
                        Object v = value;
                        return v;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        V compute(K key, CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            Object value;
            try {
                value = ComputingConcurrentHashMap.this.computingFunction.apply(key);
            }
            catch (ComputationException e) {
                ComputingConcurrentHashMap.this.setValueReference(entry, new ComputationExceptionReference(e.getCause()));
                throw e;
            }
            catch (Throwable t) {
                ComputingConcurrentHashMap.this.setValueReference(entry, new ComputationExceptionReference(t));
                throw new ComputationException(t);
            }
            if (value == null) {
                String message = ComputingConcurrentHashMap.this.computingFunction + " returned null for key " + key + ".";
                ComputingConcurrentHashMap.this.setValueReference(entry, new NullPointerExceptionReference(message));
                throw new NullPointerException(message);
            }
            this.setComputedValue(entry, value);
            return value;
        }
    }
}

