/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.PathException;
import com.google.gdata.model.QName;
import com.google.gdata.util.common.base.Objects;
import com.google.gdata.util.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path {
    public static final Path ROOT = Path.builder().build();
    private final ElementMetadata<?, ?> root;
    private final List<MetadataKey<?>> steps;
    private final boolean selectsAttribute;
    private final ElementMetadata<?, ?> selectedElement;
    private final AttributeMetadata<?> selectedAttribute;

    public static Builder builder() {
        return new Builder();
    }

    public static Path of(MetadataKey<?> ... steps) {
        Builder builder = new Builder();
        for (MetadataKey<?> step : steps) {
            builder.addStep(step);
        }
        return builder.build();
    }

    public static Path to(ElementMetadata<?, ?> root, MetadataKey<?> ... keys) {
        Builder builder = new Builder().fromRoot(root);
        for (MetadataKey<?> key : keys) {
            builder.addStep(key);
        }
        return builder.build();
    }

    private Path(Builder builder) {
        this.root = builder.root;
        this.steps = ImmutableList.copyOf((Iterable)builder.steps);
        this.selectsAttribute = builder.selectsAttribute;
        if (this.root == null) {
            this.selectedElement = null;
            this.selectedAttribute = null;
        } else {
            this.selectedElement = builder.selectedElement;
            this.selectedAttribute = builder.selectedAttribute;
        }
    }

    public boolean selectsAttribute() {
        return this.selectsAttribute;
    }

    public boolean selectsElement() {
        return !this.selectsAttribute;
    }

    public ElementMetadata<?, ?> getSelectedElement() {
        return this.selectedElement;
    }

    public AttributeMetadata<?> getSelectedAttribute() {
        return this.selectedAttribute;
    }

    public List<MetadataKey<?>> getSteps() {
        return this.steps;
    }

    public boolean isRelative() {
        return this.root == null;
    }

    public AttributeKey<?> getSelectedAttributeKey() {
        Preconditions.checkState(this.selectsAttribute, "Must select an attribute key.");
        return (AttributeKey)this.steps.get(this.steps.size() - 1);
    }

    public ElementKey<?, ?> getSelectedElementKey() {
        Preconditions.checkState(!this.steps.isEmpty(), "Must not be an empty path.");
        Preconditions.checkState(!this.selectsAttribute, "Must select an element key.");
        return (ElementKey)this.steps.get(this.steps.size() - 1);
    }

    public ElementKey<?, ?> getParentKey() {
        if (this.steps.size() > 1) {
            return (ElementKey)this.steps.get(this.steps.size() - 2);
        }
        return null;
    }

    public Path toAbsolute(ElementMetadata<?, ?> root) {
        Builder builder = new Builder().fromRoot(root);
        for (MetadataKey<?> step : this.steps) {
            builder.addStep(step);
        }
        return builder.build();
    }

    public String toString() {
        if (this.steps.isEmpty()) {
            return ".";
        }
        StringBuilder builder = new StringBuilder();
        for (MetadataKey<?> step : this.steps) {
            this.addPathSeparator(builder);
            if (step instanceof AttributeKey) {
                builder.append('@');
            }
            builder.append(step.getId());
        }
        return builder.toString();
    }

    private void addPathSeparator(StringBuilder builder) {
        if (builder.length() != 0) {
            builder.append('/');
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != Path.class) {
            return false;
        }
        Path path = (Path)o;
        return this.root == path.root && ((Object)this.steps).equals(path.steps);
    }

    public int hashCode() {
        return Objects.hashCode(this.root, this.steps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ElementMetadata<?, ?> root;
        private List<MetadataKey<?>> steps = Lists.newArrayList();
        private boolean selectsAttribute;
        private ElementMetadata<?, ?> selectedElement;
        private AttributeMetadata<?> selectedAttribute;

        private Builder() {
        }

        Builder fromRoot(ElementMetadata<?, ?> root) {
            this.root = Preconditions.checkNotNull(root);
            this.selectedElement = this.root;
            if (this.steps != null) {
                ArrayList prevSteps = Lists.newArrayList(this.steps);
                this.steps.clear();
                for (MetadataKey step : prevSteps) {
                    this.addStep(step);
                }
            }
            return this;
        }

        public Builder addStep(MetadataKey<?> step) {
            if (this.selectedElement != null) {
                if (step instanceof ElementKey) {
                    if (!this.addIfElement(step.getId())) {
                        throw new PathException("No child element matching key:" + step);
                    }
                } else if (!this.addIfAttribute(step.getId())) {
                    throw new PathException("No child attribute matching key:" + step);
                }
            } else {
                this.addToStepList(step);
            }
            return this;
        }

        public boolean addIfElement(QName id) {
            ElementKey<String, Element> elemKey;
            if (this.selectedElement != null) {
                elemKey = this.selectedElement.findElement(id);
                if (elemKey == null) {
                    return false;
                }
                this.selectedElement = this.selectedElement.bindElement(elemKey);
            } else {
                elemKey = ElementKey.of(id);
            }
            this.addToStepList(elemKey);
            return true;
        }

        public boolean addIfAttribute(QName id) {
            AttributeKey<String> attrKey;
            if (this.selectedElement != null) {
                attrKey = this.selectedElement.findAttribute(id);
                if (attrKey == null) {
                    return false;
                }
                this.selectedAttribute = this.selectedElement.bindAttribute(attrKey);
            } else {
                attrKey = AttributeKey.of(id);
            }
            this.addToStepList(attrKey);
            return true;
        }

        private void addToStepList(MetadataKey<?> step) {
            if (this.selectsAttribute) {
                throw new PathException("Cannot add to an attribute path: " + step.getId());
            }
            if (step instanceof AttributeKey) {
                this.selectsAttribute = true;
            }
            this.steps.add(step);
        }

        public Path build() {
            return new Path(this);
        }
    }
}

