/*
 * Decompiled with CFR 0.152.
 */
package lll.wrj4P5;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import lll.wrj4P5.GuitarEvent;
import lll.wrj4P5.KurakonEvent;
import lll.wrj4P5.NunchakuEvent;
import lll.wrj4P5.RimokonEvent;
import lll.wrj4P5.WiiBoard;
import lll.wrj4P5.WiiDrum;
import lll.wrj4P5.WiiGuitar;
import lll.wrj4P5.WiiKurakon;
import lll.wrj4P5.WiiNunchaku;
import lll.wrj4P5.WiiRimokon;
import processing.core.PApplet;
import processing.core.PImage;
import wiiremotej.BalanceBoard;
import wiiremotej.WiiDevice;
import wiiremotej.WiiRemote;
import wiiremotej.WiiRemoteJ;
import wiiremotej.event.BalanceBoardListener;
import wiiremotej.event.WiiDeviceDiscoveredEvent;
import wiiremotej.event.WiiDeviceDiscoveryListener;
import wiiremotej.event.WiiRemoteListener;

public class Wrj4P5
implements WiiDeviceDiscoveryListener {
    public PApplet parent;
    public int dCount;
    public int rCount;
    public int bCount;
    public static final float ONE_G = 9.80665f;
    public static final boolean IR = true;
    public static final boolean EX = false;
    private boolean isIR = false;
    private int irSens = 2;
    private int reqCount = 0;
    public WiiRimokon rimokon;
    private WiiRimokon[] rims = new WiiRimokon[7];
    public WiiBoard board;
    private WiiBoard[] brds = new WiiBoard[7];
    public WiiNunchaku nunchaku;
    public WiiKurakon kurakon;
    public WiiGuitar guitar;
    public WiiDrum drum;
    private PImage waitingImg;
    Method buttonPressed;
    Method nunchakuPressed;
    Method kurakonPressed;
    Method guitarPressed;
    Method drumPressed;
    Method boardPressed;
    Method buttonReleased;
    Method nunchakuReleased;
    Method kurakonReleased;
    Method guitarReleased;
    Method drumReleased;
    Method boardReleased;
    Method disconnected;
    Method exDisconnected;

    public Wrj4P5(PApplet parent) {
        System.setProperty("bluecove.jsr82.psm_minimum_off", "true");
        this.parent = parent;
        this.isIR = false;
        this.prepareReflection();
    }

    private void prepareReflection() {
        try {
            this.buttonPressed = this.parent.getClass().getMethod("buttonPressed", RimokonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nunchakuPressed = this.parent.getClass().getMethod("nunchakuPressed", NunchakuEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kurakonPressed = this.parent.getClass().getMethod("kurakonPressed", KurakonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.guitarPressed = this.parent.getClass().getMethod("guitarPressed", GuitarEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.drumPressed = this.parent.getClass().getMethod("drumPressed", GuitarEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.boardPressed = this.parent.getClass().getMethod("boardPressed", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.buttonReleased = this.parent.getClass().getMethod("buttonReleased", RimokonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nunchakuReleased = this.parent.getClass().getMethod("nunchakuReleased", NunchakuEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kurakonReleased = this.parent.getClass().getMethod("kurakonReleased", KurakonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.guitarReleased = this.parent.getClass().getMethod("guitarReleased", GuitarEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.drumReleased = this.parent.getClass().getMethod("guitarReleased", GuitarEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.boardReleased = this.parent.getClass().getMethod("boardReleased", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.disconnected = this.parent.getClass().getMethod("disconnected", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.exDisconnected = this.parent.getClass().getMethod("exDisconnected", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.registerDispose((Object)this);
        int i = 0;
        while (i < 7) {
            this.rims[i] = new WiiRimokon(this);
            this.brds[i] = new WiiBoard(this);
            ++i;
        }
        this.rimokon = this.rims[0];
        this.nunchaku = this.rims[0].nunchaku;
        this.kurakon = this.rims[0].kurakon;
        this.guitar = this.rims[0].guitar;
        this.drum = this.rims[0].drum;
        this.board = this.brds[0];
    }

    public Wrj4P5 connect() {
        return this.connect(1);
    }

    public Wrj4P5 connect(boolean ir) {
        return this.connect(1, ir, false);
    }

    public Wrj4P5 connect(int n) {
        return this.connect(n, false, false);
    }

    public Wrj4P5 connect(int n, boolean ir) {
        return this.connect(n, ir, false);
    }

    public Wrj4P5 connect(int n, boolean ir, boolean log) {
        return this.connect(n, ir, log, 2);
    }

    public Wrj4P5 connect(int n, boolean ir, boolean log, int sense) {
        this.isIR = ir;
        this.irSens = Math.max(4, Math.min(0, sense));
        this.reqCount = n;
        URL resource = null;
        Image img = null;
        try {
            if (log) {
                WiiRemoteJ.setConsoleLoggingAll();
            } else {
                WiiRemoteJ.setConsoleLoggingOff();
            }
            WiiRemoteJ.findDevices((WiiDeviceDiscoveryListener)this, (int)Integer.MAX_VALUE);
            System.out.println("trying to find a wii");
        }
        catch (IllegalStateException e) {
            System.out.println("!! There may be no USB dongle/device. !!");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.waitingImg == null) {
            File f = new File(String.valueOf(this.parent.online ? "" : this.parent.sketchPath("")) + "data/WiiStart.jpg");
            if (f.exists()) {
                try {
                    resource = f.toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                resource = this.getClass().getResource("WiiStart.jpg");
            }
            if (this.parent.online && resource != null) {
                img = this.parent.getImage(resource);
            } else if (resource != null) {
                img = Toolkit.getDefaultToolkit().getImage(resource);
            }
            if (img != null) {
                this.waitingImg = this.parent.loadImage(resource.toString());
            }
        }
        return this;
    }

    public void wiiDeviceDiscovered(WiiDeviceDiscoveredEvent evt) {
        int id = evt.getNumber();
        WiiDevice found = evt.getWiiDevice();
        if (found instanceof WiiRemote) {
            id = this.rCount++;
            ((WiiRemote)found).addWiiRemoteListener((WiiRemoteListener)this.rims[id]);
            this.rims[id].addTalker((WiiRemote)found, id, this.isIR, this.irSens);
            System.out.println("Discover Remote called # " + id);
        } else if (found instanceof BalanceBoard) {
            id = this.bCount++;
            ((BalanceBoard)found).addBalanceBoardListener((BalanceBoardListener)this.brds[id]);
            this.brds[id].addTalker((BalanceBoard)found, id);
            System.out.println("Discover Board called # " + id);
        }
        ++this.dCount;
        if (this.dCount == this.reqCount) {
            WiiRemoteJ.stopFind();
        }
    }

    public void findFinished(int numberFound) {
        this.dCount = numberFound;
        if (this.reqCount != this.dCount) {
            System.out.println("Finding failure. founded=" + this.dCount);
        }
    }

    public WiiBoard board(int bid) {
        return bid >= 0 && bid < 7 ? this.brds[bid] : this.board;
    }

    public WiiRimokon rimokon(int rid) {
        return rid >= 0 && rid < 7 ? this.rims[rid] : this.rimokon;
    }

    public WiiNunchaku nunchaku(int rid) {
        return rid >= 0 && rid < 7 ? this.rims[rid].nunchaku : this.nunchaku;
    }

    public WiiKurakon kurakon(int rid) {
        return rid >= 0 && rid < 7 ? this.rims[rid].kurakon : this.kurakon;
    }

    public WiiGuitar guitar(int rid) {
        return rid >= 0 && rid < 7 ? this.rims[rid].guitar : this.guitar;
    }

    public WiiDrum drum(int rid) {
        return rid >= 0 && rid < 7 ? this.rims[rid].drum : this.drum;
    }

    public void disconnected(int rid) {
        try {
            if (this.disconnected != null) {
                this.disconnected.invoke((Object)this.parent, new Integer(rid));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling controller() for " + this.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.disconnected = null;
        }
    }

    public void exDisconnected(int rid) {
        try {
            if (this.exDisconnected != null) {
                this.exDisconnected.invoke((Object)this.parent, new Integer(rid));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling controller() for " + this.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.exDisconnected = null;
        }
    }

    public void pre() {
    }

    public void dispose() {
        int i = 0;
        while (i < this.rCount) {
            this.rims[i].disconnect();
            ++i;
        }
        i = 0;
        while (i < this.bCount) {
            this.brds[i].disconnect();
            ++i;
        }
    }

    public boolean isConnecting() {
        if (this.dCount == this.reqCount) {
            return false;
        }
        this.parent.background(0);
        if (this.waitingImg != null) {
            this.parent.image(this.waitingImg, (float)(this.parent.width / 2 - this.waitingImg.width / 2), (float)(this.parent.height / 2 - this.waitingImg.height / 2));
        }
        return true;
    }
}

