/*
 * Decompiled with CFR 0.152.
 */
package lll.Loc;

import lll.Loc.Loc;
import lll.Loc.Mat;

public class Vec {
    private static double[] vNaN = new double[]{Double.NaN};
    public static final Vec NaN = new Vec(vNaN);
    public static double TOO_SMALL = 1.0E-12;
    public static double ENOUGH_SMALL = 1.0E-8;
    private double[] data;

    public Vec() {
    }

    public Vec(int length) {
        if (length > 0) {
            this.data = new double[length];
        }
    }

    public Vec(double d, int len) {
        if (len > 0) {
            if (this.data == null) {
                this.data = new double[len];
            }
            int i = 0;
            while (i < len) {
                this.data[i] = d;
                ++i;
            }
        }
    }

    public Vec(double[] d) {
        if (this.data == null) {
            this.data = new double[d.length];
        }
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public Vec(Vec v) {
        if (this.data == null) {
            this.data = new double[v.length()];
        }
        System.arraycopy(v.arrayRef(), 0, this.data, 0, v.length());
    }

    public Vec(Loc v) {
        this.data = new double[3];
        this.data[0] = v.x;
        this.data[1] = v.y;
        this.data[2] = v.z;
    }

    public Vec copy() {
        double[] out = new double[this.data.length];
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        return new Vec(out);
    }

    public Vec add(Vec v) {
        if (this.length() != v.length()) {
            return NaN.copy();
        }
        double[] outData = new double[this.length()];
        double[] vd = v.arrayRef();
        int idx = 0;
        while (idx < this.data.length) {
            outData[idx] = this.data[idx] + vd[idx];
            ++idx;
        }
        return new Vec(outData);
    }

    public Vec sub(Vec v) {
        if (this.length() != v.data.length) {
            return NaN.copy();
        }
        double[] outData = new double[this.data.length];
        double[] vd = v.arrayRef();
        int idx = 0;
        while (idx < this.data.length) {
            outData[idx] = this.data[idx] - vd[idx];
            ++idx;
        }
        return new Vec(outData);
    }

    public Vec mul(Vec v) {
        if (this.length() != v.data.length) {
            return NaN.copy();
        }
        double[] outData = new double[this.data.length];
        double[] vd = v.arrayRef();
        int idx = 0;
        while (idx < this.data.length) {
            outData[idx] = this.data[idx] * vd[idx];
            ++idx;
        }
        return new Vec(outData);
    }

    public Vec div(Vec v) {
        if (this.length() != v.data.length) {
            return NaN.copy();
        }
        double[] outData = new double[this.data.length];
        double[] vd = v.arrayRef();
        int idx = 0;
        while (idx < this.data.length) {
            outData[idx] = this.data[idx] / vd[idx];
            ++idx;
        }
        return new Vec(outData);
    }

    public Vec add(double d) {
        double[] outData = new double[this.data.length];
        int idx = 0;
        while (idx < this.data.length) {
            outData[idx] = this.data[idx] + d;
            ++idx;
        }
        return new Vec(outData);
    }

    public Vec sub(double d) {
        double[] outData = new double[this.data.length];
        int idx = 0;
        while (idx < this.data.length) {
            outData[idx] = this.data[idx] - d;
            ++idx;
        }
        return new Vec(outData);
    }

    public Vec mul(double d) {
        double[] outData = new double[this.data.length];
        int idx = 0;
        while (idx < this.data.length) {
            outData[idx] = this.data[idx] * d;
            ++idx;
        }
        return new Vec(outData);
    }

    public Vec div(double d) {
        double[] outData = new double[this.data.length];
        int idx = 0;
        while (idx < this.data.length) {
            outData[idx] = this.data[idx] / d;
            ++idx;
        }
        return new Vec(outData);
    }

    public double dot(Vec v) {
        double sum = 0.0;
        int i = 0;
        while (i < this.data.length) {
            sum += this.data[i] * v.elem(i);
            ++i;
        }
        return sum;
    }

    public Vec cross(Vec v) {
        if (this.data.length != v.length()) {
            return NaN.copy();
        }
        if (this.data.length != 3) {
            return NaN.copy();
        }
        return new Vec(new double[]{this.data[1] * v.elem(2) - this.data[2] * v.elem(1), this.data[2] * v.elem(0) - this.data[0] * v.elem(2), this.data[0] * v.elem(1) - this.data[1] * v.elem(0)});
    }

    public Mat tensor(Vec v) {
        if (this.data.length != v.length()) {
            return Mat.NaN.copy();
        }
        Mat ret = new Mat(this.data.length, this.data.length);
        double[][] retRef = ret.arrayRef();
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data.length) {
                retRef[i][j] = this.data[i] * v.elem(j);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double norm() {
        double ret = 0.0;
        int i = 0;
        while (i < this.data.length) {
            ret = Math.max(ret, Math.abs(this.data[i]));
            ++i;
        }
        return ret;
    }

    public double normL2() {
        return Math.sqrt(this.sqrNormL2());
    }

    public double sqrNormL2() {
        double ret = 0.0;
        int i = 0;
        while (i < this.data.length) {
            ret += this.data[i] * this.data[i];
            ++i;
        }
        return ret;
    }

    public double dist(Vec v) {
        return Math.sqrt(this.dist2(v));
    }

    public double dist2(Vec v) {
        if (this.data.length != v.length()) {
            return Double.NaN;
        }
        double sum = 0.0;
        double[] vd = v.arrayRef();
        int idx = 0;
        while (idx < this.data.length) {
            sum += (this.data[idx] - vd[idx]) * (this.data[idx] - vd[idx]);
            ++idx;
        }
        return sum;
    }

    public Vec setSubVec(Vec sub, int start, int len) {
        if (start < 0 || len - start + 1 > this.data.length) {
            return NaN.copy();
        }
        Vec subVec = new Vec(len - start + 1);
        double[] subVecData = subVec.arrayRef();
        int i = start;
        while (i < len - start) {
            this.data[i] = subVecData[i - start];
            ++i;
        }
        return this;
    }

    public Vec subVec(int start, int end) {
        if (start < 0 || end > this.data.length) {
            return NaN.copy();
        }
        Vec subVec = new Vec(end - start + 1);
        double[] subVecData = subVec.arrayRef();
        int i = start;
        while (i <= end) {
            subVecData[i - start] = this.data[i];
            ++i;
        }
        return subVec;
    }

    public Vec subVec(int[] select) {
        if (select.length == 0) {
            return NaN.copy();
        }
        Vec subVec = new Vec(select.length);
        double[] subVecData = subVec.arrayRef();
        int i = 0;
        while (i < select.length) {
            subVecData[i] = this.data[select[i]];
            ++i;
        }
        return subVec;
    }

    public double elem(int idx) {
        if (idx < 0 || idx >= this.data.length) {
            return Double.NaN;
        }
        return this.data[idx];
    }

    public int length() {
        return this.data.length;
    }

    public double[] toArray() {
        double[] out = new double[this.data.length];
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        return out;
    }

    public Loc toLoc() {
        return this.data.length == 3 ? new Loc((float)this.data[0], (float)this.data[1], (float)this.data[2]) : new Loc(Float.NaN, Float.NaN, Float.NaN);
    }

    public double[] arrayRef() {
        return this.data;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Vec(");
        if (this.data != null) {
            int i = 0;
            while (i < this.data.length) {
                res.append(this.data[i]);
                if (i < this.data.length - 1) {
                    res.append(" ,");
                }
                ++i;
            }
        }
        res.append(")");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vec)) {
            return false;
        }
        Vec m = (Vec)object;
        if (m.length() != this.data.length) {
            return false;
        }
        int idx = 0;
        while (idx < this.data.length) {
            if (Double.doubleToLongBits(this.data[idx]) != Double.doubleToLongBits(m.elem(idx))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public boolean hasNaN() {
        int idx = 0;
        while (idx < this.data.length) {
            if (Double.isNaN(this.data[idx])) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public boolean hasInf() {
        int idx = 0;
        while (idx < this.data.length) {
            if (Double.isInfinite(this.data[idx])) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public boolean isNaN() {
        int idx = 0;
        while (idx < this.data.length) {
            if (Double.isNaN(this.data[idx]) || Double.isInfinite(this.data[idx])) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public double polyValueAt(double x) {
        double ret = this.data[0];
        int i = 1;
        while (i < this.data.length) {
            ret *= ret * x + this.data[i];
            ++i;
        }
        return ret;
    }

    public Vec realRoots(double b) {
        Mat root = this.solve(b);
        double[][] rRef = root.arrayRef();
        int n = 0;
        int i = 0;
        while (i < root.colDim()) {
            if (ENOUGH_SMALL * Math.abs(rRef[0][i]) > Math.abs(rRef[1][i])) {
                ++n;
            } else {
                rRef[0][n] = rRef[0][i];
            }
            ++i;
        }
        int m = n;
        int i2 = 0;
        while (i2 < n - 1) {
            int j = i2 + 1;
            while (j < n) {
                if (Math.abs(rRef[0][i2] - rRef[0][j]) < TOO_SMALL) {
                    if (j + 1 < n) {
                        rRef[0][j] = rRef[0][j + 1];
                    }
                    --m;
                }
                ++j;
            }
            ++i2;
        }
        double[] ret = new double[m];
        System.arraycopy(rRef[0], 0, ret, 0, m);
        return new Vec(ret);
    }

    public Mat solve(double b) {
        double err;
        int n = this.data.length;
        Mat ret = new Mat(2, n);
        double[][] retRef = ret.arrayRef();
        double[] a = new double[n + 1];
        int i = 0;
        while (i < n) {
            a[i] = this.data[i] / this.data[0];
            ++i;
        }
        a[n] = -b / this.data[0];
        double[] g = new double[]{-a[1] / (double)n, Math.random() / (double)n};
        double max = 0.0;
        int i2 = 1;
        while (i2 <= n) {
            max = Math.max(max, Math.abs(a[i2]));
            ++i2;
        }
        double[] r = new double[]{Math.abs(g[0]) + 1.0 + max, 0.0};
        int i3 = 0;
        while (i3 < n) {
            double theta = (double)(2 * i3) * Math.PI / (double)n + Math.PI / (double)(2 * n);
            retRef[0][i3] = g[0] + r[0] * Math.cos(theta);
            retRef[1][i3] = g[1] + r[1] * Math.sin(theta);
            ++i3;
        }
        do {
            err = 0.0;
            i3 = 0;
            while (i3 < n) {
                double w2;
                double w1;
                double f1 = 1.0;
                double f2 = 0.0;
                int j = 0;
                while (j < n) {
                    w1 = f1 * retRef[0][i3] - f2 * retRef[1][i3];
                    w2 = f2 * retRef[0][i3] + f1 * retRef[1][i3];
                    f1 = w1 + a[j + 1];
                    f2 = w2;
                    ++j;
                }
                double p1 = 1.0;
                double p2 = 0.0;
                j = 0;
                while (j < n) {
                    if (j != i3) {
                        w1 = p1 * (retRef[0][i3] - retRef[0][j]) - p2 * (retRef[1][i3] - retRef[1][j]);
                        w2 = p1 * (retRef[1][i3] - retRef[1][j]) + p2 * (retRef[0][i3] - retRef[0][j]);
                        p1 = w1;
                        p2 = w2;
                    }
                    ++j;
                }
                double a1 = (f1 * p1 + f2 * p2) / (p1 * p1 + p2 * p2);
                double a2 = (f2 * p1 - f1 * p2) / (p1 * p1 + p2 * p2);
                err = Math.max(err, Math.sqrt(a1 * a1 + a2 * a2));
                double[] dArray = retRef[0];
                int n2 = i3;
                dArray[n2] = dArray[n2] - a1;
                double[] dArray2 = retRef[1];
                int n3 = i3++;
                dArray2[n3] = dArray2[n3] - a2;
            }
        } while (err > ENOUGH_SMALL);
        return ret;
    }
}

