/*
 * Decompiled with CFR 0.152.
 */
package lll.Loc;

import lll.Loc.Loc;
import lll.Loc.Vec;

public class Rod {
    private Loc stern;
    private Loc fore;
    private float length;
    private Rod last = null;
    private float lastDist;
    private Loc lastT;
    private Loc lastS;

    private Rod() {
    }

    public Rod(Loc s, Loc b) {
        this.stern = new Loc(s);
        Loc diff = b.sub(s);
        this.fore = diff.unit();
        this.length = diff.norm();
    }

    public Rod(Rod frm) {
        this.stern = frm.stern();
        this.fore = frm.fore();
        this.length = frm.length();
    }

    public Object clone() {
        return new Rod(this);
    }

    public Loc at(float t) {
        return this.stern.add(this.fore.mul(t));
    }

    public Rod move(Loc to) {
        this.stern = this.stern.move(to);
        this.last = null;
        return this;
    }

    public Rod shift(Loc diff) {
        this.stern = this.stern.shift(diff);
        this.last = null;
        return this;
    }

    public Rod shiftI(Loc diff) {
        this.stern = this.stern.shiftI(diff);
        this.last = null;
        return this;
    }

    public Rod scale(float factor) {
        this.length *= factor;
        return this;
    }

    public Rod scaleI(float factor) {
        this.length /= factor;
        return this;
    }

    public Loc intersect2D(Rod b) {
        float d2 = this.cross2D(this.fore, b.fore);
        if ((double)Math.abs(d2) < 0.01) {
            return null;
        }
        return this.at(this.cross2D(b.fore, this.fore) / d2);
    }

    public float signedDist2D(Loc pt) {
        if ((double)this.length < Vec.TOO_SMALL) {
            return this.stern.dist(pt);
        }
        return this.cross2D(this.fore, pt.sub(this.stern));
    }

    public Rod ortho(Loc pt) {
        float s = -this.fore.dot(this.stern.sub(pt));
        return new Rod(pt, this.at(s));
    }

    public float dist(Loc pt) {
        float s = -this.fore.dot(this.stern.sub(pt));
        return pt.dist(this.at(s));
    }

    public boolean having(Loc pt) {
        return (double)this.dist(pt) < Vec.ENOUGH_SMALL;
    }

    public Rod nearest(Rod to) {
        if (this.last != null && this.last.equals(to)) {
            return new Rod(this.lastS, this.lastT);
        }
        this.intersectAnalysis(to);
        return new Rod(this.lastS, this.lastT);
    }

    public float dist2D(Loc pt) {
        return Math.abs(this.signedDist2D(pt));
    }

    public float dist(Rod to) {
        if (this.last != null && this.last.equals(to)) {
            return this.lastDist;
        }
        this.intersectAnalysis(to);
        return this.lastDist;
    }

    public boolean crossing(Rod to) {
        if (this.last != null && this.last.equals(to)) {
            return (double)this.lastDist < Vec.ENOUGH_SMALL;
        }
        this.intersectAnalysis(to);
        return (double)this.lastDist < Vec.ENOUGH_SMALL;
    }

    public float length() {
        return this.length;
    }

    public Loc stern() {
        return (Loc)this.stern.clone();
    }

    public Loc bow() {
        return this.stern.add(this.fore.mul(this.length));
    }

    public Loc fore() {
        return (Loc)this.fore.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rod)) {
            return false;
        }
        Rod m = (Rod)object;
        if (Float.floatToIntBits(this.length) != Float.floatToIntBits(m.length)) {
            return false;
        }
        if (!this.stern.equals(m.stern)) {
            return false;
        }
        return this.fore.equals(m.fore);
    }

    public String toString() {
        return "Rod[" + this.stern + " - " + this.bow() + "]";
    }

    private float cross2D(Loc frm, Loc to) {
        return frm.x * to.y - frm.y * to.x;
    }

    private void intersectAnalysis(Rod to) {
        this.last = to;
        float cth = this.fore.cosine(to.fore);
        float sth2 = 1.0f - cth * cth;
        Loc AB = to.stern.sub(this.stern);
        float s = AB.dot(this.fore.sub(to.fore.mul(cth))) / sth2;
        float t = -AB.dot(to.fore.sub(this.fore.mul(cth))) / sth2;
        this.lastS = this.at(s);
        this.lastT = to.at(t);
        this.lastDist = this.lastS.dist(this.lastT);
    }
}

