/*
 * Decompiled with CFR 0.152.
 */
package lll.Loc;

import lll.Loc.Loc;
import lll.Loc.Vec;

public class Mat {
    public static final Mat NaN = new Mat(Vec.NaN);
    private double[][] data = null;
    private double[][] lu = null;
    private int[] permutation = null;
    private int parity = 1;

    public Mat() {
    }

    public Mat(int rows, int cols) {
        if (rows > 0 && cols > 0) {
            this.data = new double[rows][cols];
            this.lu = null;
        }
    }

    public Mat(double d, int rows, int cols) {
        if (rows > 0 && cols > 0) {
            this.data = new double[rows][cols];
            this.lu = null;
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < cols) {
                    this.data[i][j] = d;
                    ++j;
                }
                ++i;
            }
        }
    }

    public Mat(double[][] d) {
        this.copyIn(d);
        this.lu = null;
    }

    public Mat(Mat m) {
        this.copyIn(m.arrayRef());
        this.lu = null;
    }

    public Mat(double[] v) {
        int nRows = v.length;
        this.data = new double[nRows][1];
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v[row];
            ++row;
        }
    }

    public Mat(Vec v) {
        int nRows = v.arrayRef().length;
        this.data = new double[nRows][1];
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v.elem(row);
            ++row;
        }
    }

    public Mat(Loc v) {
        this.data = new double[3][1];
        this.data[0][0] = v.x;
        this.data[1][0] = v.y;
        this.data[2][0] = v.z;
    }

    public Mat copy() {
        return new Mat(this.copyOut());
    }

    public Mat add(Mat m) {
        if (this.colDim() != m.colDim() || this.rowDim() != m.rowDim()) {
            return NaN.copy();
        }
        int rows = this.rowDim();
        int cols = this.colDim();
        double[][] outData = new double[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                outData[row][col] = this.data[row][col] + m.elem(row, col);
                ++col;
            }
            ++row;
        }
        return new Mat(outData);
    }

    public Mat sub(Mat m) {
        if (this.colDim() != m.colDim() || this.rowDim() != m.rowDim()) {
            return NaN.copy();
        }
        int rows = this.rowDim();
        int cols = this.colDim();
        double[][] outData = new double[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                outData[row][col] = this.data[row][col] - m.elem(row, col);
                ++col;
            }
            ++row;
        }
        return new Mat(outData);
    }

    public Mat add(double d) {
        int rowCount = this.rowDim();
        int columnCount = this.colDim();
        double[][] outData = new double[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col] + d;
                ++col;
            }
            ++row;
        }
        return new Mat(outData);
    }

    public Mat mul(double d) {
        int rows = this.rowDim();
        int cols = this.colDim();
        double[][] outData = new double[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                outData[row][col] = this.data[row][col] * d;
                ++col;
            }
            ++row;
        }
        return new Mat(outData);
    }

    public Mat mul(Mat m) {
        if (this.colDim() != m.rowDim()) {
            return NaN.copy();
        }
        int nRows = this.rowDim();
        int nCols = m.colDim();
        int nSum = this.colDim();
        double[][] outData = new double[nRows][nCols];
        double sum = 0.0;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                sum = 0.0;
                int i = 0;
                while (i < nSum) {
                    sum += this.data[row][i] * m.elem(i, col);
                    ++i;
                }
                outData[row][col] = sum;
                ++col;
            }
            ++row;
        }
        return new Mat(outData);
    }

    public Mat preMul(Mat m) {
        return m.mul(this);
    }

    public double[][] toArray() {
        return this.copyOut();
    }

    public double[][] arrayRef() {
        return this.data;
    }

    public double norm() {
        double maxColSum = 0.0;
        int col = 0;
        while (col < this.colDim()) {
            double sum = 0.0;
            int row = 0;
            while (row < this.rowDim()) {
                sum += Math.abs(this.data[row][col]);
                ++row;
            }
            maxColSum = Math.max(maxColSum, sum);
            ++col;
        }
        return maxColSum;
    }

    public Mat subMat(int startRow, int endRow, int startColumn, int endColumn) {
        if (startRow < 0 || startRow > endRow || endRow > this.data.length || startColumn < 0 || startColumn > endColumn || endColumn > this.data[0].length) {
            return NaN.copy();
        }
        Mat subMat = new Mat(endRow - startRow + 1, endColumn - startColumn + 1);
        double[][] subMatrixData = subMat.arrayRef();
        int i = startRow;
        while (i <= endRow) {
            int j = startColumn;
            while (j <= endColumn) {
                subMatrixData[i - startRow][j - startColumn] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return subMat;
    }

    public Mat subMat(int[] selectedRows, int[] selectedColumns) {
        if (selectedRows.length * selectedColumns.length == 0) {
            return NaN.copy();
        }
        Mat subMatrix = new Mat(selectedRows.length, selectedColumns.length);
        double[][] subMatrixData = subMatrix.arrayRef();
        int i = 0;
        while (i < selectedRows.length) {
            int j = 0;
            while (j < selectedColumns.length) {
                subMatrixData[i][j] = this.data[selectedRows[i]][selectedColumns[j]];
                ++j;
            }
            ++i;
        }
        return subMatrix;
    }

    public Mat rowMat(int row) {
        if (!this.isValidCoordinate(row, 0)) {
            return NaN.copy();
        }
        int ncols = this.colDim();
        double[][] out = new double[1][ncols];
        System.arraycopy(this.data[row], 0, out[0], 0, ncols);
        return new Mat(out);
    }

    public Mat colMat(int column) {
        if (!this.isValidCoordinate(0, column)) {
            return NaN.copy();
        }
        int nRows = this.rowDim();
        double[][] out = new double[nRows][1];
        int row = 0;
        while (row < nRows) {
            out[row][0] = this.data[row][column];
            ++row;
        }
        return new Mat(out);
    }

    public Vec rowVec(int row) {
        if (!this.isValidCoordinate(row, 0)) {
            return Vec.NaN.copy();
        }
        int ncols = this.colDim();
        Vec out = new Vec(ncols);
        System.arraycopy(this.data[row], 0, out.arrayRef(), 0, ncols);
        return out;
    }

    public Vec colVec(int col) {
        if (!this.isValidCoordinate(0, col)) {
            return Vec.NaN.copy();
        }
        int nRows = this.rowDim();
        Vec out = new Vec(nRows);
        int row = 0;
        while (row < nRows) {
            out.arrayRef()[row] = this.data[row][col];
            ++row;
        }
        return out;
    }

    public double elem(int row, int column) {
        if (!this.isValidCoordinate(row, column)) {
            return Double.NaN;
        }
        return this.data[row][column];
    }

    public Mat transpose() {
        int nRows = this.rowDim();
        int nCols = this.colDim();
        Mat out = new Mat(nCols, nRows);
        double[][] outData = out.arrayRef();
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                outData[col][row] = this.data[row][col];
                ++col;
            }
            ++row;
        }
        return out;
    }

    public Mat inverse() {
        return this.solve(this.rightIdentity());
    }

    public double det() {
        if (!this.isSquare()) {
            return Double.NaN;
        }
        if (this.isSingular()) {
            return 0.0;
        }
        double det = this.parity;
        int i = 0;
        while (i < this.rowDim()) {
            det *= this.lu[i][i];
            ++i;
        }
        return det;
    }

    public boolean isSquare() {
        return this.colDim() == this.rowDim();
    }

    public boolean isSingular() {
        if (this.lu == null) {
            return this.luDecompose() == null || this.luDecompose().equals(NaN);
        }
        return false;
    }

    public Mat leftIdentity() {
        int dim = this.rowDim();
        Mat out = new Mat(dim, dim);
        double[][] d = out.arrayRef();
        int row = 0;
        while (row < dim) {
            int col = 0;
            while (col < dim) {
                d[row][col] = row == col ? 1.0 : 0.0;
                ++col;
            }
            ++row;
        }
        return out;
    }

    public Mat rightIdentity() {
        int dim = this.colDim();
        Mat out = new Mat(dim, dim);
        double[][] d = out.arrayRef();
        int row = 0;
        while (row < dim) {
            int col = 0;
            while (col < dim) {
                d[row][col] = row == col ? 1.0 : 0.0;
                ++col;
            }
            ++row;
        }
        return out;
    }

    public int rowDim() {
        return this.data.length;
    }

    public int colDim() {
        return this.data[0].length;
    }

    public double trace() {
        if (!this.isSquare()) {
            return Double.NaN;
        }
        double trace = this.data[0][0];
        int i = 1;
        while (i < this.rowDim()) {
            trace += this.data[i][i];
            ++i;
        }
        return trace;
    }

    public Vec operate(Vec v) {
        if (v.length() != this.colDim()) {
            return Vec.NaN.copy();
        }
        int nRows = this.rowDim();
        int nCols = this.colDim();
        Vec out = new Vec(v.length());
        double[] vref = v.arrayRef();
        double[] outref = out.arrayRef();
        int row = 0;
        while (row < nRows) {
            double sum = 0.0;
            int i = 0;
            while (i < nCols) {
                sum += this.data[row][i] * vref[i];
                ++i;
            }
            outref[row] = sum;
            ++row;
        }
        return out;
    }

    public Vec preMul(Vec v) {
        int nRows = this.rowDim();
        if (v.length() != nRows) {
            return Vec.NaN.copy();
        }
        int nCols = this.colDim();
        Vec out = new Vec(nCols);
        double[] vref = v.arrayRef();
        double[] outref = out.arrayRef();
        int col = 0;
        while (col < nCols) {
            double sum = 0.0;
            int i = 0;
            while (i < nRows) {
                sum += this.data[i][col] * vref[i];
                ++i;
            }
            outref[col] = sum;
            ++col;
        }
        return out;
    }

    public Vec solve(Vec b) {
        int nRows = this.rowDim();
        if (b.length() != nRows) {
            return Vec.NaN.copy();
        }
        Mat bMatrix = new Mat(b);
        double[][] solution = this.solve(bMatrix).arrayRef();
        double[] out = new double[nRows];
        int row = 0;
        while (row < nRows) {
            out[row] = solution[row][0];
            ++row;
        }
        return new Vec(out);
    }

    public Vec leqValueAt(Vec x) {
        return this.operate(x);
    }

    public Mat solve(Mat b) {
        int j;
        int i;
        if (b.rowDim() != this.rowDim()) {
            return NaN.copy();
        }
        if (!this.isSquare()) {
            return NaN.copy();
        }
        if (this.isSingular()) {
            return NaN.copy();
        }
        int nCol = this.colDim();
        int nColB = b.colDim();
        int nRowB = b.rowDim();
        double[][] bp = new double[nRowB][nColB];
        int row = 0;
        while (row < nRowB) {
            int col = 0;
            while (col < nColB) {
                bp[row][col] = b.elem(this.permutation[row], col);
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < nCol) {
            i = col + 1;
            while (i < nCol) {
                j = 0;
                while (j < nColB) {
                    double[] dArray = bp[i];
                    int n = j;
                    dArray[n] = dArray[n] - bp[col][j] * this.lu[i][col];
                    ++j;
                }
                ++i;
            }
            ++col;
        }
        col = nCol - 1;
        while (col >= 0) {
            int j2 = 0;
            while (j2 < nColB) {
                double[] dArray = bp[col];
                int n = j2++;
                dArray[n] = dArray[n] / this.lu[col][col];
            }
            i = 0;
            while (i < col) {
                j = 0;
                while (j < nColB) {
                    double[] dArray = bp[i];
                    int n = j;
                    dArray[n] = dArray[n] - bp[col][j] * this.lu[i][col];
                    ++j;
                }
                ++i;
            }
            --col;
        }
        Mat outMat = new Mat(bp);
        return outMat;
    }

    public Mat luDecompose() {
        int nCols;
        int nRows = this.rowDim();
        if (nRows != (nCols = this.colDim())) {
            return NaN.copy();
        }
        this.lu = this.toArray();
        this.permutation = new int[nRows];
        int row = 0;
        while (row < nRows) {
            this.permutation[row] = row;
            ++row;
        }
        this.parity = 1;
        int col = 0;
        while (col < nCols) {
            double sum = 0.0;
            int row2 = 0;
            while (row2 < col) {
                sum = this.lu[row2][col];
                int i = 0;
                while (i < row2) {
                    sum -= this.lu[row2][i] * this.lu[i][col];
                    ++i;
                }
                this.lu[row2][col] = sum;
                ++row2;
            }
            int max = col;
            double largest = 0.0;
            int row3 = col;
            while (row3 < nRows) {
                sum = this.lu[row3][col];
                int i = 0;
                while (i < col) {
                    sum -= this.lu[row3][i] * this.lu[i][col];
                    ++i;
                }
                this.lu[row3][col] = sum;
                if (Math.abs(sum) > largest) {
                    largest = Math.abs(sum);
                    max = row3;
                }
                ++row3;
            }
            if (Math.abs(this.lu[max][col]) < Vec.TOO_SMALL) {
                this.lu = null;
                return NaN.copy();
            }
            if (max != col) {
                double tmp = 0.0;
                int i = 0;
                while (i < nCols) {
                    tmp = this.lu[max][i];
                    this.lu[max][i] = this.lu[col][i];
                    this.lu[col][i] = tmp;
                    ++i;
                }
                int temp = this.permutation[max];
                this.permutation[max] = this.permutation[col];
                this.permutation[col] = temp;
                this.parity = -this.parity;
            }
            row3 = col + 1;
            while (row3 < nRows) {
                double[] dArray = this.lu[row3];
                int n = col;
                dArray[n] = dArray[n] / this.lu[col][col];
                ++row3;
            }
            ++col;
        }
        return new Mat(this.lu);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Mat{");
        if (this.data != null) {
            int i = 0;
            while (i < this.data.length) {
                res.append(i > 0 ? "\n" : "");
                res.append(i > 0 ? "    {" : "{");
                int j = 0;
                while (j < this.data[0].length) {
                    if (j > 0) {
                        res.append(", ");
                    }
                    res.append(this.data[i][j]);
                    ++j;
                }
                res.append(i == this.data.length - 1 ? "}" : "},");
                ++i;
            }
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Mat)) {
            return false;
        }
        Mat m = (Mat)object;
        int nRows = this.rowDim();
        int nCols = this.colDim();
        if (m.colDim() != nCols || m.rowDim() != nRows) {
            return false;
        }
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                if (Double.doubleToLongBits(this.data[row][col]) != Double.doubleToLongBits(m.elem(row, col))) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public boolean hasNaN() {
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data[i].length) {
                if (Double.isNaN(this.data[i][j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean hasInf() {
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data[i].length) {
                if (Double.isInfinite(this.data[i][j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isNaN() {
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data[i].length) {
                if (Double.isNaN(this.data[i][j]) || Double.isInfinite(this.data[i][j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public Mat setSubMat(double[][] subMatrix, int row, int column) {
        if (row < 0 || column < 0) {
            return NaN.copy();
        }
        int nRows = subMatrix.length;
        if (nRows == 0) {
            return NaN.copy();
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            return NaN.copy();
        }
        int r = 1;
        while (r < nRows) {
            if (subMatrix[r].length != nCols) {
                return NaN.copy();
            }
            ++r;
        }
        if (this.data == null) {
            if (row > 0 || column > 0) {
                return NaN.copy();
            }
            this.data = new double[nRows][nCols];
            System.arraycopy(subMatrix, 0, this.data, 0, subMatrix.length);
        }
        if (nRows + row > this.rowDim() || nCols + column > this.colDim()) {
            return NaN.copy();
        }
        int i = 0;
        while (i < nRows) {
            System.arraycopy(subMatrix[i], 0, this.data[row + i], column, nCols);
            ++i;
        }
        this.lu = null;
        return this;
    }

    public Mat setSubMat(Mat subMatrix, int row, int column) {
        if (row < 0 || column < 0) {
            return NaN.copy();
        }
        double[][] subRef = subMatrix.arrayRef();
        int nRows = subRef.length;
        if (nRows == 0) {
            return NaN.copy();
        }
        int nCols = subRef[0].length;
        if (nCols == 0) {
            return NaN.copy();
        }
        int r = 1;
        while (r < nRows) {
            if (subRef[r].length != nCols) {
                return NaN.copy();
            }
            ++r;
        }
        if (this.data == null) {
            if (row > 0 || column > 0) {
                return NaN.copy();
            }
            this.data = new double[nRows][nCols];
            System.arraycopy(subRef, 0, this.data, 0, subRef.length);
        }
        if (nRows + row > this.rowDim() || nCols + column > this.colDim()) {
            return NaN.copy();
        }
        int i = 0;
        while (i < nRows) {
            System.arraycopy(subRef[i], 0, this.data[row + i], column, nCols);
            ++i;
        }
        this.lu = null;
        return this;
    }

    public Mat setRowVec(Vec rowVec, int row) {
        if (row < 0) {
            return NaN.copy();
        }
        int nCols = rowVec.length();
        if (nCols == 0) {
            return NaN.copy();
        }
        if (this.data == null) {
            this.data = new double[row + 1][nCols];
        }
        nCols = Math.min(nCols, this.data.length);
        System.arraycopy(rowVec.arrayRef(), 0, this.data[row], 0, nCols);
        this.lu = null;
        return this;
    }

    public Mat setColVec(Vec colVec, int col) {
        if (col < 0) {
            return NaN.copy();
        }
        int nRows = colVec.length();
        if (nRows == 0) {
            return NaN.copy();
        }
        if (this.data == null) {
            this.data = new double[nRows][col + 1];
        }
        nRows = Math.min(nRows, this.data[0].length);
        int i = 0;
        while (i < nRows) {
            this.data[i][col] = colVec.elem(i);
            ++i;
        }
        this.lu = null;
        return this;
    }

    protected int[] getPermutation() {
        int[] out = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, out, 0, this.permutation.length);
        return out;
    }

    private double[][] copyOut() {
        int nRows = this.rowDim();
        double[][] out = new double[nRows][this.colDim()];
        int i = 0;
        while (i < nRows) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
            ++i;
        }
        return out;
    }

    private void copyIn(double[][] in) {
        this.setSubMat(in, 0, 0);
    }

    private boolean isValidCoordinate(int row, int col) {
        int nRows = this.rowDim();
        int nCols = this.colDim();
        return row >= 0 && row <= nRows - 1 && col >= 0 && col <= nCols - 1;
    }
}

