import lll.Loc.*;

public class UniCorr extends Vfunc {
	public UniCorr() {
		super(1,2);// dim of domain is 1, dim of parameters is 2
	}
	public double valueAt(Vec x, Vec p) {
		return p.elem(0)*x.elem(0) + p.elem(1);	// f(x) = ax+b
	}
	public Vec gradAt(Vec x, Vec p) {
		return new Vec(new double[]{p.elem(0)});	// fx'(x) = a
	}
	public Vec gradParamAt(Vec x, Vec p) {
		return new Vec(new double[]{x.elem(0),1});		// fp'(p) = (x, 1)
	}
}
