import lll.Loc.*;

public class MulCorr extends Vfunc {
	public MulCorr() {
		super(3,4);// dim of domain is 3, dim of parameters is 4
	}
	public double valueAt(Vec x, Vec p) {			// f(x) = ax+by+cz+d
		return p.elem(0)*x.elem(0) + p.elem(1)*x.elem(1)
				+ p.elem(2)*x.elem(2) + p.elem(3);
	}
	public Vec gradAt(Vec x, Vec p) {				// f'(x) = (a,b,c)
		return new Vec(
				new double[]{p.elem(0), p.elem(1), p.elem(2)} );
	}
	public Vec gradParamAt(Vec x, Vec p) {			// fp'(p) = (x,y,z,1)
		return new Vec(
				new double[]{x.elem(0), x.elem(1), x.elem(2), 1});
	}
}
