import lll.Loc.*;

//8. estimate multi-variated non-linear regression coeficient, 
//f8(x) = a / (b + c^x) - modified Logistic curve 
public class ModifiedLogistic extends Vfunc {
	public ModifiedLogistic() {
		super(1,3);// dim of domain is 1, dim of parameters is 3
	}
	public double valueAt(Vec x, Vec p) {	// f(x) = a / (b + c^x) 
		return p.elem(0) / (p.elem(1) + Math.pow(p.elem(2),x.elem(0)) );
	}
	public Vec gradAt(Vec x, Vec p) {	// f'(x) = (-a*ln(c)/(b+c^x)^2)
		return this.diffAt(x, p.mul(.01), p);
	}
	public Vec gradParamAt(Vec x, Vec p) {	
		// fp'(p) = (1,  -1/b^2,
		//				-x*c^(x-1)/c^2x )
		double xx=x.elem(0), b=p.elem(1), c=p.elem(2);
		return new Vec(
		    new double[]{1,  -1/Math.pow(b, 2),
		    				-xx*Math.pow(c, xx-1) / Math.pow(c, 2*xx) } );
	}
/*	public Vec gradParamAt(Vec x, Vec p) {	
		// f(p) = f(a,b,c,d) = a / (b + c^x)
		// fp'(p) = ( 1/(b+c^x),
		//			-a/(b+c^x)^2,
		//			-a*x*c^(x-1)/(b+c^x+d^y)^2  )
		double xx=x.elem(0), a=p.elem(0), b=p.elem(1), c=p.elem(2);
		double denomi = b + Math.pow(c, xx);
		return new Vec(
			new double[]{1/denomi, -a/denomi/denomi,
					-a*xx/denomi*Math.pow(c, xx-1)/denomi } );
	}*/
}
