import lll.Loc.*;

public class PolyFunc extends Vfunc {
	public PolyFunc() {
		super(1,0);
	}
	public double valueAt(Vec x, Vec p) {	// f(x) = x^3 + 3x^2 + 4x + 2
		double v = x.elem(0);
		return v*v*v + 3*v*v + 4*v + 2;
	}
	public Vec gradAt(Vec x, Vec p) {		// f'(x) = 3x^2 + 6x + 4
		double v = x.elem(0);
		return new Vec(3*v*v+6*v+4, 1);
	}
	public Vec gradParamAt(Vec x, Vec p) {	// no parameter fitting needed
		return Vec.NaN.copy();
	}
}
