/*
 * Decompiled with CFR 0.152.
 */
package lll.wrj4P5;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import lll.wrj4P5.KurakonEvent;
import lll.wrj4P5.NunchakuEvent;
import lll.wrj4P5.RimokonEvent;
import lll.wrj4P5.WiiKurakon;
import lll.wrj4P5.WiiNunchaku;
import lll.wrj4P5.WiiRimokon;
import processing.core.PApplet;
import processing.core.PImage;
import wiiremotej.WiiRemote;
import wiiremotej.WiiRemoteJ;
import wiiremotej.event.WiiRemoteDiscoveredEvent;
import wiiremotej.event.WiiRemoteDiscoveryListener;
import wiiremotej.event.WiiRemoteListener;

public class Wrj4P5
implements WiiRemoteDiscoveryListener {
    public PApplet parent;
    public static int rCount;
    public static final float ONE_G = 9.80665f;
    public static final boolean IR = true;
    public static final boolean EX = false;
    private boolean isIR = false;
    public static WiiRimokon rimokon;
    private static WiiRimokon[] rims;
    public static WiiNunchaku nunchaku;
    private static WiiNunchaku[] nuns;
    public static WiiKurakon kurakon;
    private static WiiKurakon[] kurs;
    private static PImage waitingImg;
    Method buttonPressed;
    Method nunchakuPressed;
    Method kurakonPressed;
    Method buttonReleased;
    Method nunchakuReleased;
    Method kurakonReleased;
    Method disconnected;
    Method exDisconnected;

    static {
        rims = new WiiRimokon[7];
        nuns = new WiiNunchaku[7];
        kurs = new WiiKurakon[7];
    }

    public Wrj4P5(PApplet parent) {
        this.parent = parent;
        this.isIR = true;
        this.prepareReflection();
    }

    public Wrj4P5(PApplet parent, boolean mode) {
        this.parent = parent;
        this.isIR = mode;
        this.prepareReflection();
    }

    private void prepareReflection() {
        try {
            this.buttonPressed = this.parent.getClass().getMethod("buttonPressed", RimokonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nunchakuPressed = this.parent.getClass().getMethod("nunchakuPressed", NunchakuEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kurakonPressed = this.parent.getClass().getMethod("kurakonPressed", KurakonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.buttonReleased = this.parent.getClass().getMethod("buttonReleased", RimokonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nunchakuReleased = this.parent.getClass().getMethod("nunchakuReleased", NunchakuEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kurakonReleased = this.parent.getClass().getMethod("kurakonReleased", KurakonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.disconnected = this.parent.getClass().getMethod("disconnected", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.exDisconnected = this.parent.getClass().getMethod("exDisconnected", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.registerDispose((Object)this);
        int i = 0;
        while (i < 7) {
            Wrj4P5.rims[i] = new WiiRimokon(this);
            ++i;
        }
        rimokon = rims[0];
        nunchaku = Wrj4P5.rims[0].nunchaku;
        kurakon = Wrj4P5.rims[0].kurakon;
    }

    public Wrj4P5 connect() {
        return this.connect(1L);
    }

    public Wrj4P5 connect(long n) {
        return this.connect(n, false, false);
    }

    public Wrj4P5 connect(long n, boolean ir) {
        return this.connect(n, ir, false);
    }

    public Wrj4P5 connect(long n, boolean ir, boolean log) {
        this.isIR = ir;
        URL resource = null;
        Image img = null;
        try {
            if (log) {
                WiiRemoteJ.setConsoleLoggingAll();
            } else {
                WiiRemoteJ.setConsoleLoggingOff();
            }
            WiiRemoteJ.findRemotes((WiiRemoteDiscoveryListener)this, (int)((int)(0L < n && n < 8L ? n : 1L)));
            System.out.println("trying to find a wii");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (waitingImg == null) {
            File f = new File(String.valueOf(this.parent.online ? "" : this.parent.sketchPath("")) + "data/WiiStart.jpg");
            if (f.exists()) {
                try {
                    resource = f.toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                resource = this.getClass().getResource("WiiStart.jpg");
            }
            if (this.parent.online && resource != null) {
                img = this.parent.getImage(resource);
            } else if (resource != null) {
                img = Toolkit.getDefaultToolkit().getImage(resource);
            }
            if (img != null) {
                waitingImg = this.parent.loadImageSync(img);
            }
        }
        return this;
    }

    public void wiiRemoteDiscovered(WiiRemoteDiscoveredEvent evt) {
        int id = evt.getNumber();
        WiiRemote found = evt.getWiiRemote();
        found.addWiiRemoteListener((WiiRemoteListener)rims[id]);
        rims[id].addTalker(found, id, this.isIR);
        System.out.println("Discover called # " + id);
    }

    public void findFinished(int numberFound) {
        rCount = numberFound;
    }

    public WiiRimokon rimokon(int rid) {
        return rid >= 0 && rid < rCount ? rims[rid] : rimokon;
    }

    public WiiNunchaku nunchaku(int rid) {
        return rid >= 0 && rid < rCount ? nuns[rid] : nunchaku;
    }

    public WiiKurakon kurakon(int rid) {
        return rid >= 0 && rid < rCount ? kurs[rid] : kurakon;
    }

    public void disconnected(int rid) {
        try {
            if (this.disconnected != null) {
                this.disconnected.invoke((Object)this.parent, new Integer(rid));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling controller() for " + this.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.disconnected = null;
        }
    }

    public void exDisconnected(int rid) {
        try {
            if (this.exDisconnected != null) {
                this.exDisconnected.invoke((Object)this.parent, new Integer(rid));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling controller() for " + this.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.exDisconnected = null;
        }
    }

    public void pre() {
    }

    public void dispose() {
        int i = 0;
        while (i < rCount) {
            rims[i].disconnect();
            ++i;
        }
    }

    public boolean isConnecting() {
        if (rCount > 0) {
            return false;
        }
        this.parent.background(0);
        if (waitingImg != null) {
            this.parent.image(waitingImg, (float)(this.parent.width / 2 - Wrj4P5.waitingImg.width / 2), (float)(this.parent.height / 2 - Wrj4P5.waitingImg.height / 2));
        }
        return true;
    }
}

