/*
 Main part of the WRJ4P5 lib - http://www.geocities.jpn/classiclll_newweb/libs/WRJ4P5
 
 the Model of the Wii device for Processing/Proce55ing/P5

 Copyright (c) 2007 Classiclll

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
 */

package lll.wrj4P5;
import processing.core.*;
import wiiremotej.*;
import wiiremotej.event.*;

//import java.awt.Image;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Wrj4P5 is the base class for managing the available WiiRemotes and extentions. 
 * It provides you with methods to get information from and 
 * to communicate with them  on your sketch. 
 * @example wrj4p5_MyFirstWii
 * @related WiiRimokon
 * @related RimokonEvent
 * @related WiiNunchaku
 * @related NunchakuEvent
 * @related WiiKurakon
 * @related KurakonEvent
 */

public class Wrj4P5 implements WiiRemoteDiscoveryListener {
  public PApplet parent;
  public static int rCount;// the number of WiiRemotes connected.(at most 7)
  public static final float ONE_G = 9.80665f; // Gravity_Unit(m/sec/sec)

  public static WiiRimokon rimokon;   //WiiRemoteAdapter=Listener is the WiiRemote, first connected.
  private static WiiRimokon[] rims = new WiiRimokon[7];// connected WiiRemotes(at most 7)

  public static WiiNunchaku nunchaku; //WiiNunchakuExtentionListener is the Nunchuk of the first WiiRemote.
  private static WiiNunchaku[] nuns = new WiiNunchaku[7];// connected Nunchuks(at most 7)

  public static WiiKurakon kurakon;   //WiiClassicControllerListener  is the ClassicController of the first WiiRemote.
  private static WiiKurakon[] kurs = new WiiKurakon[7];// connected ClassicControllers(at most 7)
  
  private static PImage waitingImg;

  /**
   * void buttonPressed(RimokonEvent ev, int rid) Call when some button pressed on WiiRemote.
   * Method to check if the parent Applet calls buttonPressed
   */
  Method buttonPressed;
  /**
   * void nunchakuPressed(NunchukEvent ev, int rid) Call when some button/stick pressed on Nunchuk.
   * Method to check if the parent Applet calls nunchakuPressed
   */
  Method nunchakuPressed;
  /**
   * void kurakonPressed(KurakonEvent ev, int rid) Call when some button/stick pressed on Classic Controller.
   * Method to check if the parent Applet calls kurakonPressed
   */
  Method kurakonPressed;
  /**
   * void disconnected(int rid) Call when some WiiRemote is disconnected.
   * Method to check if the parent Applet calls disconnected
   */
  Method disconnected;
  /**
   * void exDisconnected(int rid) Call when a Nunchuk/ClassicController is disconnected from some WiiRemote.
   * Method to check if the parent Applet calls exDisconnected
   */
  Method exDisconnected;
 /*
  *constructor
  */
  public Wrj4P5(PApplet parent) {
    this.parent = parent;
// void buttonPressed(RimokonEvent ev, int rid) Call when some button pressed on WiiRemote.
	try{
		buttonPressed = parent.getClass().getMethod("buttonPressed", new Class[] {RimokonEvent.class,Integer.TYPE});
	}catch (Exception e){/* just ignore */ }
// void nunchakuPressed(NunchukEvent ev, int rid) Call when some button/stick pressed on Nunchuk.
	try{
		nunchakuPressed = parent.getClass().getMethod("nunchakuPressed", new Class[] {NunchakuEvent.class,Integer.TYPE});
	}catch (Exception e){/* just ignore */ }
// void kurakonPressed(KurakonEvent ev, int rid) Call when some button/stick pressed on Classic Controller.
	try{
		kurakonPressed = parent.getClass().getMethod("kurakonPressed", new Class[] {KurakonEvent.class,Integer.TYPE});
	}catch (Exception e){/* just ignore */ }
// void disconnected(int rid) Call when some WiiRemote is disconnected.
	try{
		disconnected = parent.getClass().getMethod("disconnected", new Class[] {Integer.TYPE});
	}catch (Exception e){/* just ignore */ }
// void exDisconnected(int rid) Call when a Nunchuk/ClassicController is disconnected from some WiiRemote.
	try{
		exDisconnected = parent.getClass().getMethod("exDisconnected", new Class[] {Integer.TYPE});
	}catch (Exception e){/* just ignore */ }
//
//
//	this.parent.registerPre(this);// The requirement of PApplet of Proce55ing
//	try{
//		Method registerPre = parent.getClass().getMethod("registerPre", new Class[] {Object.class});
//	   	try{
//			registerPre.invoke(parent, new Object[] {this});
//		}catch (Exception e){ e.printStackTrace();}
//	}catch (Exception e){/* just ignore */ }
    this.parent.registerDispose(this);// The requirement of PApplet of Proce55ing
//	try{
//		Method registerDispose = parent.getClass().getMethod("registerDispose", new Class[] {Object.class});
//	   	try{
//	   		registerDispose.invoke(parent, new Object[] {this});
//		}catch (Exception e){ e.printStackTrace();}
//	}catch (Exception e){/* just ignore */ }
	for (int i=0;i<7;i++) rims[i]=new WiiRimokon(this);
	rimokon=rims[0];
	nunchaku=rims[0].nunchaku;
	kurakon=rims[0].kurakon;
  }

/*
  connect one or more remotesB
*/
  public Wrj4P5 connect() {
	  return this.connect(1);
  }
  public Wrj4P5 connect(long n) {
	  return this.connect(n,false);
  }
  public Wrj4P5 connect(long n, boolean log)
  {      
		URL resource = null;
		Image img = null;
		try {
			if (log) {WiiRemoteJ.setConsoleLoggingAll();}
			else 	{WiiRemoteJ.setConsoleLoggingOff();} 
			WiiRemoteJ.findRemotes(this, (int) (0<n&&n<8 ? n : 1));
			System.out.println("trying to find a wii");
		} catch (IllegalStateException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
// get the path of varid CodeBase, both under online and offline. thanky you, fjen. 
		if (waitingImg==null) {
			File f = new File((parent.online?"": parent.sketchPath("")) + "data/WiiStart.jpg"); 
			if (f.exists()) { 
				try {
					resource = f.toURL();
				} catch (MalformedURLException e) {
					e.printStackTrace();
				}
			} else {
				resource = this.getClass().getResource("WiiStart.jpg");
			}
//
		    if (parent.online && resource!=null) {
		      img = parent.getImage(resource);
		    } 
		    else if (resource!=null) {
		      img = Toolkit.getDefaultToolkit().getImage(resource);
		    }
		    if (img!=null) waitingImg = parent.loadImageSync(img);
		}
		return this;
  }

  public void wiiRemoteDiscovered(WiiRemoteDiscoveredEvent evt) {
	  	int id = evt.getNumber();
	  	WiiRemote found = evt.getWiiRemote();
	    found.addWiiRemoteListener(rims[id]);
		rims[id].addTalker(found,id);
		System.out.println("Discover called # " + id);
	}

  public void findFinished(int numberFound) {
        rCount = numberFound;		
  }
// return the (rid+1).th WiiRemote, or null if no connected.
  public WiiRimokon rimokon(int rid) {
	  return (0<=rid&&rid<rCount ? rims[rid] : rimokon);
  }
// return the (rid+1).th Nunchuk, or null if no connected.
  public WiiNunchaku nunchaku(int rid) {
	  return (0<=rid&&rid<rCount ? nuns[rid] : nunchaku);
  }
// return the (rid+1).th ClassicController, or null if not connected.
  public WiiKurakon kurakon(int rid) {
	  return (0<=rid&&rid<rCount ? kurs[rid] : kurakon);
  }
//
  public void disconnected(int rid) {
   	try{
		if (disconnected != null) 
			disconnected.invoke(
				parent, 
				new Object[] {
					new Integer(rid),
				}
			);
	}catch (Exception e){
		System.err.println("Disabling controller() for " + parent.getName() + " because of an error.");
		e.printStackTrace();
		disconnected = null;
	}
  }
//
  public void exDisconnected(int rid) {
   	try{
		if (exDisconnected != null) 
			exDisconnected.invoke(
				parent, 
				new Object[] {
					new Integer(rid),
				}
			);
	}catch (Exception e){
		System.err.println("Disabling controller() for " + parent.getName() + " because of an error.");
		e.printStackTrace();
		exDisconnected = null;
	}
  }
//
  public void pre() {
//	TODO
  }
 
  public void dispose() {
	  for(int i=0;i<rCount;i++) rims[i].disconnect();
  }

// Only part needs PApplet
  public boolean isConnecting() {
	if (rCount>0) return false;
	parent.background(0);
	if (waitingImg!=null) parent.image(waitingImg
							,parent.width/2-waitingImg.width/2
							,parent.height/2-waitingImg.height/2
							);
	return true;
  }
}