package lll.wrj4P5;
import wiiremotej.*;
import wiiremotej.event.*;
import javax.sound.sampled.*;

import lll.Loc.*;

/**
 * Implements WiiRemoteListener and acts as a WiiRemoteController.
 * Note that you can ignore the main method pretty much, as it mostly has to do with the graphs and GUIs.
 * At the very end though, there's an example of how to connect to a remote and how to prebuffer audio files.
 * @author Classiclll
 * @version 6/06/07
 */

public class WiiRimokon extends WiiRemoteAdapter
{    
//ypropatiesz
    public long tNow = 0;			// current senced cycle.
    
    public Loc senced = new Loc();	// latest senced 3D(Loc) acceleration measured by Gravity Constant.
	public Loc acc = new Loc();		// latest senced 3D(Loc) accelerationim/sec/sec)
//	 TODO
//	public Loc vel = new Loc();		// latest senced 3D(Loc) velocity(m/sec)
//	public Loc pos = new Loc();		// latest senced 3D(Loc) location(m)
//	public Loc cursor = new Loc();	// latest senced 2D(Loc) location(%) of the cross cursor.

//	public Loc angAcc = new Loc();	// 3D(Loc) angular acceleration(rad/sec/sec) - will need a fixed nunchuk
//	public Loc angVel = new Loc();	// 3D(Loc) angular velocity(rad/sec) - will need a fixed nunchuk
//	public Loc direction = new Loc();	// 3D(Loc) normalized direction - will need a fixed nunchuk
	
	public WiiNunchaku nunchaku;		// the Nunchuk connected, or null if no connected.
	public WiiKurakon kurakon;		// the ClassicController connected, or null if no connected.
	public Loc[] irLights;			// 2D position and size of each IRlights, 3rd entry is a size of light
	   
	private Wrj4P5 parent;
	private WiiRemote talker;
	private int myId;
	private Loc pSenced = new Loc();	// previous senced value.
	private float batteryLevel;
	private boolean[] isIlluminated = {false, false, false, false}; //status of 4 LEDs
	private PrebufferedSound prebuf;
	private float viblationMagnitude=1;
	private boolean isModurate=false;
	private long viblationInterval=40;
	private boolean isVibrating=false;
	private long lastCom = 0;
	private long birthTime;
    
    public WiiRimokon(Wrj4P5 wii)
    {
    	   super();
    	   nunchaku = new WiiNunchaku();
    	   kurakon = new WiiKurakon();
    	   this.parent = wii;
    }

    public WiiRemote addTalker(WiiRemote talker, int id)
    {
 	   myId = id;
	   this.talker = talker;
	   birthTime = System.currentTimeMillis();
    	   try {
   			talker.setAccelerometerEnabled(true);
   			talker.setSpeakerEnabled(true);
   			talker.setLEDLights(isIlluminated);
			talker.setIRSensorEnabled(true, WRIREvent.BASIC);
    	   } catch(Exception e) {e.printStackTrace();}
    	   return talker;
    }
    
    public void disconnected()
    {
        System.out.println("Remote disconnected... Please Wii again.");
        parent.disconnected(myId);
    }
    
    public void statusReported(WRStatusEvent evt)
    {
        batteryLevel = (float) evt.getBatteryLevel()/200;
        isIlluminated = evt.getLEDStatus();
 //       System.out.println("isContinuousEnabled = "+evt.isContinuousEnabled());
    }
    
    public void IRInputReceived(WRIREvent evt)
    {
    		for (int i=0;i<1;i++){
    			irLights[i].move((float) evt.getIRLights()[i].getX(),
    							(float) evt.getIRLights()[i].getY(),
    							(float) evt.getIRLights()[i].getSize());
    		}
    }
    
    public void accelerationInputReceived(WRAccelerationEvent evt)
    {
            pSenced.move(senced);
            senced.move(	(float)evt.getXAcceleration(),
            				(float)evt.getYAcceleration(),
            				(float)evt.getZAcceleration()
            			  );
            acc.move(senced.mul(Wrj4P5.ONE_G)); 
            tNow++;            
    }
    
    public void extensionInputReceived(WRExtensionEvent evt)
    {
        if (evt instanceof WRNunchukExtensionEvent) {
        		nunchaku.inputEvent((WRNunchukExtensionEvent)evt);
         	try{
        			if (parent.nunchakuPressed != null) 
        				parent.nunchakuPressed.invoke(
        					parent.parent, 
        					new Object[] {
        						new NunchakuEvent((WRNunchukExtensionEvent) evt), 
        						new Integer(myId),
        					}
        				);
        		}catch (Exception e){
        			System.err.println("Disabling nunchuk() for " + (parent.parent).getName() + " because of an error.");
        			e.printStackTrace();
        		}
        } else if (evt instanceof WRClassicControllerExtensionEvent) {
        		kurakon.inputEvent((WRClassicControllerExtensionEvent)evt);
             try{
        			if (parent.kurakonPressed != null) 
        				parent.kurakonPressed.invoke(
        					parent.parent, 
        					new Object[] {
        						new KurakonEvent((WRClassicControllerExtensionEvent) evt), 
        						new Integer(myId),
        					}
        				);
        		}catch (Exception e){
        			System.err.println("Disabling controller() for " + (parent.parent).getName() + " because of an error.");
        			e.printStackTrace();
        		}
        } else {
        		System.err.println("Unknown extension connected!");
        }
    	}
    
    public void extensionConnected(WiiRemoteExtension extension)
    {
        System.out.println("Extension connected!");
        try
        {
            talker.setExtensionEnabled(true);
        }catch(Exception e){e.printStackTrace();}
    }
    
    public void extensionPartiallyInserted()
    {
//    	 TODO
        System.out.println("Extension(#"+myId+") partially inserted. Push it in more next time, jerk!");
    }
    
    public void extensionUnknown()
    {
// 		TODO
    		System.out.println("Extension(#"+myId+") unknown. Did you try to plug in a toaster or something?");
    }
    
    public void extensionDisconnected(WiiRemoteExtension extension)
    {
        System.out.println("Extension(#"+myId+") disconnected. Why'd you unplug it, retard?");
        parent.exDisconnected(myId);
    }
       
    public void buttonInputReceived(WRButtonEvent evt)
    {
    		if (!isJustPressed(evt)) return;
 		try{
			if (parent.buttonPressed != null) {
				parent.buttonPressed.invoke(
					parent.parent, 
					new Object[] {
						new RimokonEvent(evt), 
						new Integer(myId),
					}
				);
			}
		}catch (Exception e){
			System.err.println("Disabling remote() for " + (parent.parent).getName() + " because of an error.");
			e.printStackTrace();
		}
     }

 // <connection/communication>
    public void disconnect() { //disconnect the WiiRemote device
    		if (talker != null) {talker.disconnect();nunchaku=null;kurakon=null;talker=null;}
    		parent.disconnected(myId);
    }
//
    public boolean isConnected() {
    		return (canCommunicateMe() ? talker.isConnected() : false);
    }
    public boolean isExtensionConnected() {
    		return (canCommunicateMe() ? talker.isExtensionConnected() : false);
    }
    public void requestStatus() { // start getting the newest status report
    		if (!canCommunicateMe()) return;
    		try {
    			if (!talker.isReadingData()) talker.requestStatus();
    		} catch (Exception e){System.out.println(e);}
    }
    public boolean isReadingData() { // check if getting status
    		return (canCommunicateMe() ? talker.isReadingData() : false);
    }

//  <Battery>
    public float getBatteryLevel() { // get the latest battery level, 0(empty) to 1(full)
    		return batteryLevel;
    }

//  <LED Lights>
    public boolean isLED(int lid) { // check the specified LED illumination.
	    if (canCommunicateMe()) isIlluminated = talker.getLEDLights();
		return isIlluminated[(lid<0?0:(lid>3?3:lid))];
    }
    public void setLED(int lid, boolean illumination) { //set the specified LED illumination.
		try {
			isIlluminated[lid]=illumination;
			if (canCommunicateMe()) talker.setLEDLights(isIlluminated);
 	   } catch(Exception e) {e.printStackTrace();}
    }
    public boolean[] getLEDs() { //check the all LEDs illumination.
    	    if (canCommunicateMe()) isIlluminated = talker.getLEDLights();
		return isIlluminated;
    }
    public void setLEDs(boolean[] illumination) { //set the each LEDs illumination.
		try {
			boolean isSame = true;
			for (int i=0;i<4;i++) isSame = isSame && (isIlluminated[i]==illumination[i]);
			if (!isSame && canCommunicateMe()) {
				talker.setLEDLights(illumination);
				for (int i=0;i<4;i++) isIlluminated[i]=illumination[i];
			}
 	   } catch(Exception e) {e.printStackTrace();}
    }

//  <Speaker>
    public void bufferSound(AudioInputStream audioIn) { // prepare the prebufferd sound.(only one)
		try {
			prebuf = WiiRemote.bufferSound(audioIn);
		} catch (Exception e){System.out.println(e);}
    }
    public float getVolume() {// check the speaker's volume level, min(0) to max(1)
    		return (canCommunicateMe() ? (float) talker.getSpeakerVolume() : 0);
    }
    public void setVolume(float volume) {// set the speaker's volume level, min(0) to max(1)
    		if (!canCommunicateMe()) return;
    		try {
    			talker.setSpeakerVolume(volume);
    		} catch (Exception e){System.out.println(e);}
   }
    public boolean isPlaying() {// check if playing sound.
    		return (canCommunicateMe() ? talker.isPlayingSound() : false);
    }
    public void playBuffer() { // play the prebufferd sound.
    		if (!canCommunicateMe()) return;
    		try {
    			talker.playPrebufferedSound(prebuf, WiiRemote.SF_ADPCM4U);
    		} catch (Exception e){System.out.println(e);}
    }
    public void play(AudioInputStream audioIn) {// play the specified AudioInputStream sound.
		if (!canCommunicateMe()) return;
    		try {
    			talker.playSound(audioIn, WiiRemote.SF_ADPCM4U);
    		} catch (Exception e){System.out.println(e);}
    }
    public void stopSound() {// stop sound.
		if (canCommunicateMe()) talker.stopSound();
    }   
//    <Vibrator>
    public boolean isVibrating() {// check if vibrating
		return (canCommunicateMe() ? isVibrating=talker.isVibrating() : isVibrating);
    }
    public float getVibrationMagnitude(int magnitude) {// get vibration magnitude.(0 to 1)
    		return viblationMagnitude;
    }
    public void setVibrationMagnitude(int magnitude) {// set vibration magnitude.(0 to 1)
    		viblationMagnitude = (magnitude<0?0:(magnitude>1?1:magnitude));
    		isModurate = (magnitude>.9);
    		viblationInterval = (long) (20+200*(1-viblationMagnitude));
    }
    public void startVibrating() {// start vibration with current mag.
		if (!canCommunicateMe()) return;
		try {
			if (!isModurate) talker.startVibrating();
			else talker.startModulatedVibrating(viblationInterval);
		} catch (Exception e){System.out.println(e);}
    }
    public void vibrateFor(long time) {// vibration for given duration.(ms)
		if (!canCommunicateMe()) return;
		try {
			if (!isModurate) talker.vibrateFor((time>10?time:10));
			else talker.modulatedVibrateFor((time>10?time:10), viblationInterval);
		} catch (Exception e){System.out.println(e);e.printStackTrace();}
	}
    public void stopVibrating() {// stop vibration.
		if (!canCommunicateMe()) return;
		try {
			if (!isModurate) talker.stopModulatedVibrating();
			else talker.stopVibrating();
		} catch (Exception e){System.out.println(e);}
    }
    
//    <IRsencer>
    public boolean isIRSensorEnabled() {// check IRsensor enabled.
    		return (canCommunicateMe() ? talker.isIRSensorEnabled() : false);
    }

//	utilities
    private boolean canCommunicateMe() {
    		if (talker==null) return false;
		long now = System.currentTimeMillis();
		if (now-birthTime<3000 || !talker.isConnected()) return false;
		long dlt = now-lastCom;
		if (dlt>100) lastCom = now;
    		return (dlt>100);
    }
    
    private boolean isJustPressed(WRButtonEvent evt){
        return (evt.wasPressed(WRButtonEvent.TWO) || evt.wasPressed(WRButtonEvent.ONE)
        		|| evt.wasPressed(WRButtonEvent.B) || evt.wasPressed(WRButtonEvent.A)
        		|| evt.wasPressed(WRButtonEvent.MINUS) || evt.wasPressed(WRButtonEvent.HOME)
        		|| evt.wasPressed(WRButtonEvent.LEFT) || evt.wasPressed(WRButtonEvent.RIGHT)
        		|| evt.wasPressed(WRButtonEvent.DOWN) || evt.wasPressed(WRButtonEvent.UP)
        		|| evt.wasPressed(WRButtonEvent.PLUS));
    }
}