/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Random;
import org.tanukisoftware.wrapper.WrapperJNIError;
import org.tanukisoftware.wrapper.WrapperLicenseError;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;

public class RuntimeExec {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Random rand = new Random();
        System.out.println(Main.getRes().getString("Is DYNAMIC supported? A:") + WrapperProcessConfig.isSupported((int)4));
        System.out.println(Main.getRes().getString("Is FORK_EXEC supported? A:") + WrapperProcessConfig.isSupported((int)2));
        System.out.println(Main.getRes().getString("Is VFORK_EXEC supported? A:") + WrapperProcessConfig.isSupported((int)3));
        System.out.println(Main.getRes().getString("Is POSIX_SPAWN supported? A:") + WrapperProcessConfig.isSupported((int)1));
        block50: for (int i = 1; i < 8; ++i) {
            switch (i) {
                case 1: {
                    WrapperProcess proc;
                    System.out.println(i + Main.getRes().getString(" start a small child process, dont care about output but call waitfor..."));
                    try {
                        proc = WrapperManager.exec((String)"../test/simplewaiter 65 1");
                        proc.getOutputStream().close();
                        System.out.println(Main.getRes().getString("{0} small child process {1} is alive {2}", new Object[]{new Integer(i), new Integer(proc.getPID()), new Boolean(proc.isAlive())}));
                        System.out.println(Main.getRes().getString("{0} child process (PID= {1}) finished with code {2}", new Object[]{new Integer(i), new Integer(proc.getPID()), new Integer(proc.waitFor())}));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 2: {
                    WrapperProcess proc;
                    System.out.println(i + Main.getRes().getString(" start longrunning child process dont wait..."));
                    try {
                        System.out.println(i + Main.getRes().getString(" first, try to vfork..."));
                        if (WrapperProcessConfig.isSupported((int)3)) {
                            System.out.println(i + Main.getRes().getString(" vfork is supported"));
                            proc = WrapperManager.exec((String)("../test/simplewaiter " + (rand.nextInt(200) + 1) + " " + rand.nextInt(30)), (WrapperProcessConfig)new WrapperProcessConfig().setStartType(3));
                        } else {
                            System.out.println(i + Main.getRes().getString(" vfork is not supported"));
                            proc = WrapperManager.exec((String)("../test/simplewaiter " + (rand.nextInt(200) + 1) + " " + rand.nextInt(30)));
                        }
                        System.out.println(i + Main.getRes().getString(" longrunning child process {0} is alive {1}", new Object[]{new Integer(proc.getPID()), new Boolean(proc.isAlive())}));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 3: {
                    Object p;
                    try {
                        System.out.println(i + Main.getRes().getString(" spawn a small child process..."));
                        if (WrapperProcessConfig.isSupported((int)1)) {
                            System.out.println(i + Main.getRes().getString(" posix_spawn is supported."));
                            p = WrapperManager.exec((String)"../test/simplewaiter 0 15", (WrapperProcessConfig)new WrapperProcessConfig().setStartType(1));
                        } else {
                            System.out.println(i + Main.getRes().getString(" spawn is not supported."));
                            p = WrapperManager.exec((String)"../test/simplewaiter 0 15");
                        }
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        try {
                            String line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(i + " out..:" + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 4: {
                    WrapperProcessConfig wpm;
                    System.out.println(i + Main.getRes().getString(" start a small child process, change the environment and read output..."));
                    try {
                        String line;
                        wpm = new WrapperProcessConfig();
                        Map environment = wpm.getEnvironment();
                        System.out.println(i + Main.getRes().getString(" size of Environment map (before calling clear()) = ") + environment.size());
                        environment.clear();
                        environment.put("TEST", "TEST123");
                        System.out.println(i + Main.getRes().getString(" size of Environment map = ") + environment.size());
                        WrapperProcess proc = WrapperManager.exec((String)("../test/simplewaiter " + rand.nextInt(200) + " 3"), (WrapperProcessConfig)wpm);
                        proc.getOutputStream().close();
                        System.out.println(i + Main.getRes().getString(" small child process {0} is alive {1}", new Object[]{new Integer(proc.getPID()), new Boolean(proc.isAlive())}));
                        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        try {
                            line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(i + " out..:" + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                        br = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        try {
                            line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(line);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 5: {
                    String line;
                    BufferedReader br;
                    WrapperProcess proc;
                    WrapperProcessConfig wpm;
                    System.out.println(i + Main.getRes().getString(" start longrunning child process, change working dir, call waitFor and finally read output..."));
                    try {
                        wpm = new WrapperProcessConfig();
                        if (WrapperProcessConfig.isSupported((int)2) || WrapperProcessConfig.isSupported((int)3)) {
                            wpm.setStartType(WrapperProcessConfig.isSupported((int)2) ? 2 : 3);
                            System.out.println(i + Main.getRes().getString(" changing the working directory is supported"));
                            wpm.setWorkingDirectory(new File(".."));
                        } else {
                            System.out.println(i + Main.getRes().getString(" changing the working directory is not supported"));
                        }
                        try {
                            System.out.println(i + Main.getRes().getString(" try to call dir"));
                            proc = WrapperManager.exec((String)"cmd.exe /c dir", (WrapperProcessConfig)wpm);
                        }
                        catch (IOException e) {
                            System.out.println(i + Main.getRes().getString(" dir failed. most likely we are not on Windows, try ls -l before giving up."));
                            proc = WrapperManager.exec((String)"ls -l", (WrapperProcessConfig)wpm);
                        }
                        System.out.println(i + " PID = " + proc.getPID());
                        System.out.println(i + Main.getRes().getString(" child process (PID= {0}) finished with code ", (Object)new Integer(proc.getPID())) + proc.waitFor());
                        System.out.println(i + Main.getRes().getString(" now read the output"));
                        br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        try {
                            line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(i + " out..:" + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 6: {
                    String line;
                    BufferedReader br;
                    WrapperProcess proc;
                    Object p;
                    try {
                        System.out.println(i + Main.getRes().getString(" start a small child process by Runtime.exec and put a wrapperexec in between.."));
                        p = Runtime.getRuntime().exec("../test/simplewaiter " + (rand.nextInt(200) + 1) + " " + (rand.nextInt(20) + 1));
                        proc = WrapperManager.exec((String)"../test/simplewaiter 4 4");
                        proc.getOutputStream().close();
                        System.out.println(i + Main.getRes().getString(" small child process {0} is alive {1}", new Object[]{new Integer(proc.getPID()), new Boolean(proc.isAlive())}));
                        br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        try {
                            line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(i + " out..:" + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                        System.out.println(i + " " + p.toString() + Main.getRes().getString(" Runtime.exec exit ") + ((Process)p).waitFor());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 7: {
                    WrapperProcess proc;
                    System.out.println(i + Main.getRes().getString(" start invalid child process..."));
                    try {
                        proc = WrapperManager.exec((String)"invalid");
                        System.out.println(i + Main.getRes().getString(" invalid child process is alive ") + proc.isAlive());
                        continue block50;
                    }
                    catch (IOException e) {
                        System.out.println(i + Main.getRes().getString(" caught an invalid child process..."));
                    }
                }
            }
        }
        try {
            System.out.println(Main.getRes().getString("finally start a long-running child process attached to the wrapper, the wrapper will shut down soon, so the child process should get killed by the wrapper..."));
            WrapperProcess p = WrapperManager.exec((String)"../test/simplewaiter 2 1000", (WrapperProcessConfig)new WrapperProcessConfig().setDetached(true));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WrapperJNIError e) {
            e.printStackTrace();
        }
        catch (WrapperLicenseError e) {
            e.printStackTrace();
        }
        System.out.println(Main.getRes().getString("All Done."));
    }
}

